/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi.ui;

import com.rusefi.AverageAnglePanel;
import com.rusefi.OutputChannel;
import com.rusefi.core.Sensor;
import com.rusefi.core.SensorCentral;
import com.rusefi.io.CommandQueue;
import com.rusefi.io.InvocationConfirmationListener;
import com.rusefi.trigger.TriggerShapeHolder;
import com.rusefi.ui.util.UiUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.Date;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.Timer;

public class Wizard {
    private final JPanel panel = new JPanel(new BorderLayout());
    private final JPanel content = new JPanel();
    private final JButton button = new JButton("Trigger Wizard");
    private final WizardStepImpl TRIGGER_WIZARD_HELLO = new WizardStepImpl(){

        @Override
        public Component getContent() {
            JButton button = new JButton("Hello, let's test trigger. Click this to process");
            button.addActionListener(new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Wizard.this.applyStep(nextStep);
                }
            });
            return button;
        }
    };

    public Wizard() {
        this.TRIGGER_WIZARD_HELLO.setNext(new SendCommand("disable injection")).setNext(new SendCommand("disable ignition")).setNext(new SendCommand("chartsize " + 10 * TriggerShapeHolder.CURRENT.getTotalToothCount() * 2)).setNext(new SendCommand("subscribe " + OutputChannel.WaveChartCurrentSize.getProtocolId())).setNext(new SendCommand("subscribe " + OutputChannel.RunningTriggerError.getProtocolId())).setNext(new SendCommand("subscribe " + OutputChannel.RunningOrderingTriggerError.getProtocolId())).setNext(new SendCommand("set_analog_chart_freq 1")).setNext(new WaitForZeroRpm());
    }

    public Component createPane() {
        this.panel.add((Component)this.button, "North");
        this.panel.add((Component)this.content, "Center");
        this.panel.add((Component)new AverageAnglePanel(null).getPanel(), "South");
        this.button.addActionListener(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Wizard.this.button.setEnabled(false);
                Wizard.this.applyStep(Wizard.this.TRIGGER_WIZARD_HELLO);
            }
        });
        return this.panel;
    }

    private void applyStep(WizardStep step) {
        System.out.println(new Date() + " apply " + step);
        Component newContent = this.getContent(step);
        this.content.removeAll();
        this.content.add(newContent);
        UiUtils.trueLayout(this.content);
    }

    private Component getContent(WizardStep step) {
        Component newContent;
        if (step == null) {
            newContent = new JLabel("Wizard is done!");
            this.button.setEnabled(true);
        } else {
            newContent = step.getContent();
        }
        return newContent;
    }

    private void scheduleRepaint(int timeoutMs, final WizardStep step) {
        final AtomicReference<Timer> tHolder = new AtomicReference<Timer>();
        Timer t = new Timer(timeoutMs, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ((Timer)tHolder.get()).stop();
                Wizard.this.applyStep(step);
            }
        });
        tHolder.set(t);
        t.start();
    }

    private class WaitForZeroRpm
    extends WizardStepImpl {
        private int counter;

        private WaitForZeroRpm() {
        }

        @Override
        public Component getContent() {
            double rpm = SensorCentral.getInstance().getValue(Sensor.RPMValue);
            if (rpm == 0.0) {
                return Wizard.this.getContent(this.nextStep);
            }
            Wizard.this.scheduleRepaint(1000, this);
            return new JLabel("Current RPM: " + rpm + ", please stop the engine. Waiting " + this.counter++);
        }
    }

    class SendCommand
    extends WizardStepImpl {
        private final String command;

        SendCommand(String command) {
            this.command = command;
        }

        @Override
        public Component getContent() {
            CommandQueue instance = null;
            instance.write(this.command, 500, new InvocationConfirmationListener(){

                @Override
                public void onCommandConfirmation() {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            Wizard.this.applyStep(SendCommand.this.nextStep);
                        }
                    });
                }
            });
            return new JLabel("Sending " + this.command);
        }
    }

    static abstract class WizardStepImpl
    implements WizardStep {
        protected WizardStep nextStep;

        public WizardStepImpl setNext(WizardStepImpl nextStep) {
            this.nextStep = nextStep;
            return nextStep;
        }
    }

    static interface WizardStep {
        public Component getContent();
    }
}

