/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi.ui;

import com.devexperts.logging.Logging;
import com.rusefi.core.io.BundleUtil;
import com.rusefi.core.ui.FrameHelper;
import com.rusefi.ui.StatusConsumer;
import com.rusefi.ui.util.UiUtils;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.datatransfer.StringSelection;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;

public class StatusWindow
implements StatusConsumer {
    private static final Logging log = Logging.getLogging(StatusWindow.class);
    private static final Color LIGHT_RED = new Color(255, 102, 102);
    private static final Color LIGHT_GREEN = new Color(102, 255, 102);
    private final JTextArea logTextArea = new JTextArea();
    private final JPanel content = new JPanel(new BorderLayout());
    private final JLabel bottomStatusLabel = new JLabel();
    @NotNull
    protected final FrameHelper frameHelper = new FrameHelper();

    public StatusWindow() {
        this.logTextArea.setLineWrap(true);
        JScrollPane messagesScroll = new JScrollPane(this.logTextArea, 22, 30){

            @Override
            public Dimension getPreferredSize() {
                return new Dimension(400, 400);
            }
        };
        this.content.add((Component)messagesScroll, "Center");
        this.content.add((Component)this.bottomStatusLabel, "South");
        this.append("Console version 20230107");
        this.append("Windows " + System.getProperty("os.version"));
        this.append("Bundle " + BundleUtil.readBundleFullNameNotNull());
    }

    @NotNull
    public FrameHelper getFrameHelper() {
        return this.frameHelper;
    }

    public JPanel getContent() {
        return this.content;
    }

    public void setErrorState() {
        this.logTextArea.setBackground(LIGHT_RED);
        this.copyContentToClipboard();
    }

    public void setSuccessState() {
        this.logTextArea.setBackground(LIGHT_GREEN);
    }

    public JFrame getFrame() {
        return this.frameHelper.getFrame();
    }

    public void showFrame(String title) {
        this.frameHelper.getFrame().setTitle(title);
        this.frameHelper.showFrame(this.content, false);
        UiUtils.centerWindow(this.frameHelper.getFrame());
        this.logTextArea.setText("");
    }

    @Override
    public void append(String string) {
        SwingUtilities.invokeLater(() -> {
            String s = string.replaceAll(Character.toString('\u00db'), "");
            log.info(s);
            this.logTextArea.append(s + "\r\n");
            UiUtils.trueLayout(this.logTextArea);
        });
    }

    public void copyContentToClipboard() {
        SwingUtilities.invokeLater(() -> Toolkit.getDefaultToolkit().getSystemClipboard().setContents(new StringSelection(this.logTextArea.getText()), null));
        this.append("hint: error state is already in your clipboard, please use PASTE or Ctrl-V while reporting issues");
    }

    public void setStatus(String status) {
        this.bottomStatusLabel.setText(status);
    }
}

