/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi.ldmp;

import com.devexperts.logging.Logging;
import com.rusefi.EnumToString;
import com.rusefi.InvokeReader;
import com.rusefi.ReaderState;
import com.rusefi.ReaderStateImpl;
import com.rusefi.output.ConfigStructure;
import com.rusefi.output.ConfigurationConsumer;
import com.rusefi.output.DataLogConsumer;
import com.rusefi.output.FileJavaFieldsConsumer;
import com.rusefi.output.FragmentDialogConsumer;
import com.rusefi.output.GaugeConsumer;
import com.rusefi.output.GetOutputValueConsumer;
import com.rusefi.output.JavaSensorsConsumer;
import com.rusefi.output.OutputsSectionConsumer;
import com.rusefi.output.SdCardFieldsConsumer;
import com.rusefi.output.SdCardFieldsContent;
import com.rusefi.util.LazyFile;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.yaml.snakeyaml.Yaml;

public class LiveDataProcessor {
    private static final Logging log = Logging.getLogging(LiveDataProcessor.class);
    private static final String header = "// generated by gen_live_documentation.sh / LiveDataProcessor.java\n";
    private static final String enumContentFileName = "console/binary/generated/live_data_ids.h";
    private static final String tsOutputsDestination = "console/binary/";
    private final GaugeConsumer gaugeConsumer = new GaugeConsumer("console/binary/" + File.separator + "generated/gauges.ini");
    private final StringBuilder enumContent = new StringBuilder("// generated by gen_live_documentation.sh / LiveDataProcessor.java\n#pragma once\n\ntypedef enum {\n");
    private final StringBuilder baseAddressCHeader = new StringBuilder();
    private final StringBuilder totalSensors = new StringBuilder();
    private final StringBuilder fancyNewStuff = new StringBuilder();
    private final StringBuilder fancyNewMenu = new StringBuilder();
    private final StringBuilder fragmentsContent = new StringBuilder("// generated by gen_live_documentation.sh / LiveDataProcessor.java\n");
    private final String extraPrepend = System.getProperty("LiveDataProcessor.extra_prepend");

    public static void main(String[] args) throws IOException {
        if (args.length != 1) {
            System.err.println("One parameter expected: name of live data yaml input file");
            System.exit(-1);
        }
        String yamlFileName = args[0];
        Yaml yaml = new Yaml();
        Map data = (Map)yaml.load((Reader)new FileReader(yamlFileName));
        LiveDataProcessor liveDataProcessor = new LiveDataProcessor();
        int sensorTsPosition = liveDataProcessor.handleYaml(data);
        liveDataProcessor.writeFiles();
        log.info("TS_TOTAL_OUTPUT_SIZE=" + sensorTsPosition);
        try (FileWriter fw = new FileWriter("console/binary/generated/total_live_data_generated.h");){
            fw.write(header);
            fw.write("#define TS_TOTAL_OUTPUT_SIZE " + sensorTsPosition);
        }
        fw = new FileWriter("console/binary/generated/sensors.java");
        var7_7 = null;
        try {
            fw.write(liveDataProcessor.totalSensors.toString());
        }
        catch (Throwable throwable) {
            var7_7 = throwable;
            throw throwable;
        }
        finally {
            if (fw != null) {
                if (var7_7 != null) {
                    try {
                        fw.close();
                    }
                    catch (Throwable throwable) {
                        var7_7.addSuppressed(throwable);
                    }
                } else {
                    fw.close();
                }
            }
        }
        fw = new FileWriter("console/binary/generated/fancy_content.ini");
        var7_7 = null;
        try {
            fw.write(liveDataProcessor.fancyNewStuff.toString());
        }
        catch (Throwable throwable) {
            var7_7 = throwable;
            throw throwable;
        }
        finally {
            if (fw != null) {
                if (var7_7 != null) {
                    try {
                        fw.close();
                    }
                    catch (Throwable throwable) {
                        var7_7.addSuppressed(throwable);
                    }
                } else {
                    fw.close();
                }
            }
        }
        fw = new FileWriter("console/binary/generated/fancy_menu.ini");
        var7_7 = null;
        try {
            fw.write(liveDataProcessor.fancyNewMenu.toString());
        }
        catch (Throwable throwable) {
            var7_7 = throwable;
            throw throwable;
        }
        finally {
            if (fw != null) {
                if (var7_7 != null) {
                    try {
                        fw.close();
                    }
                    catch (Throwable throwable) {
                        var7_7.addSuppressed(throwable);
                    }
                } else {
                    fw.close();
                }
            }
        }
        liveDataProcessor.end();
    }

    private void end() throws IOException {
        this.gaugeConsumer.endFile();
    }

    private int handleYaml(Map<String, Object> data) throws IOException {
        final JavaSensorsConsumer javaSensorsConsumer = new JavaSensorsConsumer();
        final OutputsSectionConsumer outputsSections = new OutputsSectionConsumer(tsOutputsDestination + File.separator + "generated/output_channels.ini");
        final DataLogConsumer dataLogConsumer = new DataLogConsumer(tsOutputsDestination + File.separator + "generated/data_logs.ini");
        final SdCardFieldsContent sdCardFieldsConsumer = new SdCardFieldsContent();
        final GetOutputValueConsumer outputValueConsumer = new GetOutputValueConsumer("controllers/lua/generated/output_lookup_generated.cpp");
        EntryHandler handler = new EntryHandler(){

            @Override
            public void onEntry(String name, String javaName, String folder, String prepend, boolean withCDefines, String[] outputNames, String constexpr, String conditional) throws IOException {
                int startingPosition = javaSensorsConsumer.sensorTsPosition;
                log.info("Starting " + name + " at " + startingPosition + " with [" + conditional + "]");
                LiveDataProcessor.this.baseAddressCHeader.append("#define " + name.toUpperCase() + "_BASE_ADDRESS " + startingPosition + "\n");
                ReaderStateImpl state = new ReaderStateImpl();
                state.setDefinitionInputFile(folder + File.separator + name + ".txt");
                state.setWithC_Defines(withCDefines);
                state.addDestination(javaSensorsConsumer, outputsSections, dataLogConsumer);
                FragmentDialogConsumer fragmentDialogConsumer = new FragmentDialogConsumer(name);
                state.addDestination(fragmentDialogConsumer);
                if (LiveDataProcessor.this.extraPrepend != null) {
                    state.addPrepend(LiveDataProcessor.this.extraPrepend);
                }
                state.addPrepend(prepend);
                state.addCHeaderDestination(folder + File.separator + name + "_generated.h");
                int baseOffset = outputsSections.getBaseOffset();
                state.addDestination(new FileJavaFieldsConsumer(state, "../java_console/models/src/main/java/com/rusefi/config/generated/" + javaName, baseOffset));
                if (constexpr != null) {
                    sdCardFieldsConsumer.home = constexpr;
                    state.addDestination((state1, structure) -> sdCardFieldsConsumer.handleEndStruct(state1, structure));
                    outputValueConsumer.currentSectionPrefix = constexpr;
                    outputValueConsumer.conditional = conditional;
                    state.addDestination((state1, structure) -> outputValueConsumer.handleEndStruct(state1, structure));
                    state.addDestination(new ConfigurationConsumer(){

                        @Override
                        public void handleEndStruct(ReaderState readerState, ConfigStructure structure) throws IOException {
                            LiveDataProcessor.this.gaugeConsumer.handleEndStruct(readerState, structure);
                        }
                    });
                }
                state.doJob();
                LiveDataProcessor.this.fancyNewStuff.append(fragmentDialogConsumer.getContent());
                LiveDataProcessor.this.fancyNewMenu.append(fragmentDialogConsumer.menuLine());
                log.info("Done with " + name + " at " + javaSensorsConsumer.sensorTsPosition);
            }
        };
        ArrayList liveDocs = (ArrayList)data.get("Usages");
        for (LinkedHashMap entry : liveDocs) {
            String[] outputNamesArr;
            String name = (String)entry.get("name");
            String java = (String)entry.get("java");
            String folder = (String)entry.get("folder");
            String prepend = (String)entry.get("prepend");
            String constexpr = (String)entry.get("constexpr");
            String conditional = (String)entry.get("conditional_compilation");
            Boolean withCDefines = (Boolean)entry.get("withCDefines");
            withCDefines = withCDefines != null && withCDefines != false;
            Object outputNames = entry.get("output_name");
            if (outputNames == null) {
                outputNamesArr = new String[]{};
            } else if (outputNames instanceof String) {
                outputNamesArr = new String[]{(String)outputNames};
            } else {
                ArrayList nameList = (ArrayList)outputNames;
                outputNamesArr = new String[nameList.size()];
                nameList.toArray(outputNamesArr);
            }
            handler.onEntry(name, java, folder, prepend, withCDefines, outputNamesArr, constexpr, conditional);
            String enumName = "LDS_" + name;
            String type = name + "_s";
            this.enumContent.append(enumName + ",\n");
            if (outputNamesArr.length < 2) {
                this.fragmentsContent.append("decl_frag<").append(type).append(">{},\n");
                continue;
            }
            for (int i = 0; i < outputNamesArr.length; ++i) {
                if (i != 0) {
                    this.fragmentsContent.append("// ");
                }
                this.fragmentsContent.append("decl_frag<").append(type).append(", ").append(i).append(">{},\t// ").append(outputNamesArr[i]).append("\n");
            }
        }
        this.enumContent.append("} live_data_e;\n");
        LazyFile lazyFile = new LazyFile("console/binary_log/log_fields_generated.h");
        SdCardFieldsConsumer.wrapContent(lazyFile, sdCardFieldsConsumer.getBody());
        lazyFile.close();
        outputValueConsumer.endFile();
        this.totalSensors.append(javaSensorsConsumer.getContent());
        return javaSensorsConsumer.sensorTsPosition;
    }

    private void writeFiles() throws IOException {
        try (FileWriter fw = new FileWriter(enumContentFileName);){
            fw.write(this.enumContent.toString());
            fw.write(this.baseAddressCHeader.toString());
        }
        fw = new FileWriter("console/binary/generated/live_data_fragments.h");
        var2_2 = null;
        try {
            fw.write(this.fragmentsContent.toString());
        }
        catch (Throwable throwable) {
            var2_2 = throwable;
            throw throwable;
        }
        finally {
            if (fw != null) {
                if (var2_2 != null) {
                    try {
                        fw.close();
                    }
                    catch (Throwable throwable) {
                        var2_2.addSuppressed(throwable);
                    }
                } else {
                    fw.close();
                }
            }
        }
        String outputPath = "../java_console/io/src/main/java/com/rusefi/enums";
        InvokeReader request = new InvokeReader(outputPath, Collections.singletonList(enumContentFileName));
        EnumToString.handleRequest(request);
    }

    static interface EntryHandler {
        public void onEntry(String var1, String var2, String var3, String var4, boolean var5, String[] var6, String var7, String var8) throws IOException;
    }
}

