/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi.io.serial;

import com.devexperts.logging.Logging;
import com.fazecast.jSerialComm.SerialPort;
import com.fazecast.jSerialComm.SerialPortDataListener;
import com.fazecast.jSerialComm.SerialPortEvent;
import com.fazecast.jSerialComm.SerialPortThreadFactory;
import com.opensr5.io.DataListener;
import com.rusefi.NamedThreadFactory;
import com.rusefi.binaryprotocol.IncomingDataBuffer;
import com.rusefi.io.IoStream;
import com.rusefi.io.serial.AbstractIoStream;
import com.rusefi.io.serial.BaudRateHolder;
import java.io.IOException;
import org.jetbrains.annotations.Nullable;

public class SerialIoStream
extends AbstractIoStream {
    static Logging log = Logging.getLogging(SerialIoStream.class);
    @Nullable
    protected final SerialPort sp;
    protected final String port;
    private boolean withListener;

    public SerialIoStream(@Nullable SerialPort sp, String port) {
        this.sp = sp;
        this.port = port;
    }

    public static IoStream openPort(String port) {
        log.info("[SerialIoStream] openPort " + port);
        SerialPort serialPort = SerialIoStream.openSerial(port);
        return new SerialIoStream(serialPort, port);
    }

    @Nullable
    protected static SerialPort openSerial(String port) {
        SerialPort serialPort = SerialPort.getCommPort(port);
        serialPort.setBaudRate(BaudRateHolder.INSTANCE.baudRate);
        boolean openedOk = serialPort.openPort(0);
        if (!openedOk) {
            log.error("Error opening " + port + " maybe no permissions?");
            return null;
        }
        return serialPort;
    }

    @Override
    public IncomingDataBuffer getDataBuffer() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void close() {
        log.info(this.port + ": Closing port...");
        super.close();
        if (this.sp != null) {
            this.sp.closePort();
        }
        log.info(this.port + ": Closed port.");
    }

    @Override
    public void write(byte[] bytes) throws IOException {
        if (this.sp == null) {
            throw new IOException("Port was never opened");
        }
        int written = this.sp.writeBytes(bytes, bytes.length);
        if (written != bytes.length) {
            throw new IOException("write failed: wrote " + written + " but expected " + bytes.length);
        }
    }

    @Override
    public void flush() throws IOException {
    }

    @Override
    public void setInputListener(final DataListener listener) {
        if (this.withListener) {
            throw new IllegalStateException("Not possible to change listener");
        }
        this.withListener = true;
        if (this.sp == null) {
            return;
        }
        this.sp.addDataListener(new SerialPortDataListener(){
            private boolean isFirstEvent = true;

            @Override
            public int getListeningEvents() {
                return 1;
            }

            @Override
            public void serialEvent(SerialPortEvent event) {
                int bytesAvailable;
                if (event.getEventType() != 1) {
                    return;
                }
                if (this.isFirstEvent) {
                    Thread.currentThread().setName("Serial Port Event Thread");
                    this.isFirstEvent = false;
                }
                if ((bytesAvailable = SerialIoStream.this.sp.bytesAvailable()) <= 0) {
                    return;
                }
                byte[] data = new byte[bytesAvailable];
                int numRead = SerialIoStream.this.sp.readBytes(data, data.length);
                if (numRead != bytesAvailable) {
                    byte[] dataSmaller = new byte[numRead];
                    System.arraycopy(data, 0, dataSmaller, 0, numRead);
                    data = dataSmaller;
                }
                listener.onDataArrived(data);
            }
        });
    }

    static {
        log.info("Using com.fazecast.jSerialComm " + SerialPort.getVersion());
        SerialPortThreadFactory.set(new NamedThreadFactory("jSerialComm"));
    }
}

