/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi.io.can;

import com.rusefi.io.IoStream;
import com.rusefi.io.can.Elm327Connector;
import com.rusefi.io.can.IsoTpConnector;
import java.util.ArrayList;
import org.junit.Assert;
import org.junit.Test;

public class IsoTpConnectorTest {
    @Test
    public void testConnector() {
        byte[] crcWrappedCrcRequest = new byte[]{0, 5, 107, 0, 0, 80, 95, 105, -81, -96, 112};
        final ArrayList packets = new ArrayList();
        IsoTpConnector testConnector = new IsoTpConnector(){

            @Override
            public void sendCanData(byte[] hdr, byte[] data, int dataOffset, int dataLength) {
                byte[] total = 1.combineArrays(hdr, data, dataOffset, dataLength);
                String packetAsString = IoStream.printHexBinary(Elm327Connector.byteToString(total));
                packets.add(packetAsString);
            }

            @Override
            public void receiveData() {
            }
        };
        IsoTpConnector.sendStrategy(crcWrappedCrcRequest, testConnector);
        Assert.assertEquals(2L, packets.size());
        Assert.assertEquals("31 30 30 42 30 30 30 35 36 42 30 30 30 30 35 30 0D ", packets.get(0));
        Assert.assertEquals("32 31 35 46 36 39 41 46 41 30 37 30 0D ", packets.get(1));
    }
}

