/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi.io;

import com.devexperts.logging.Logging;
import com.rusefi.binaryprotocol.BinaryProtocol;
import com.rusefi.core.RusEfiSignature;
import com.rusefi.core.SignatureHelper;
import com.rusefi.core.io.BundleUtil;
import com.rusefi.io.IoStream;
import com.rusefi.ui.StatusConsumer;
import java.io.IOException;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;

public class DfuHelper {
    private static final Logging log = Logging.getLogging(DfuHelper.class);
    private static final String PREFIX = "rusefi_bundle";

    public static void sendDfuRebootCommand(IoStream stream, StatusConsumer messages) {
        byte[] command = BinaryProtocol.getTextCommandBytes("reboot_dfu");
        try {
            stream.sendPacket(command);
            stream.close();
            messages.append(String.format("Reboot command [%s] sent into %s!\n", "reboot_dfu", stream));
        }
        catch (IOException e) {
            messages.append("Error " + e);
        }
    }

    public static boolean sendDfuRebootCommand(JComponent parent, String signature, IoStream stream, StatusConsumer messages) {
        String signatureWithPrefix;
        RusEfiSignature s = SignatureHelper.parse(signature);
        String bundleName = BundleUtil.readBundleFullName();
        if (bundleName != null && s != null && !bundleName.equalsIgnoreCase(signatureWithPrefix = "all".equals(s.getBundle()) ? PREFIX : "rusefi_bundle_" + s.getBundle()) && !bundleName.contains("_QC_")) {
            String message = String.format("You have \"%s\" controller does not look right to program it with \"%s\"", s.getBundle(), bundleName);
            log.info(message);
            SwingUtilities.invokeLater(() -> {
                JOptionPane.showMessageDialog(parent, message);
                new Thread(() -> {
                    BinaryProtocol.sleep(5000L);
                    System.exit(-5);
                }).start();
            });
            return false;
        }
        DfuHelper.sendDfuRebootCommand(stream, messages);
        return true;
    }
}

