/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi.autotune.test;

import com.rusefi.autotune.AfrDataPoint;
import com.rusefi.autotune.FuelAutoTune;
import com.rusefi.autotune.MathUtil;
import com.rusefi.autotune.Result;
import java.util.ArrayList;
import org.junit.Assert;
import org.junit.Test;

public class FuelAutoTuneTest {
    private static final double EPS = 1.0E-5;

    @Test
    public void testAlreadyTuned() {
        double value = 0.7;
        double[][] veTable = FuelAutoTuneTest.createVeTable(value);
        ArrayList<AfrDataPoint> dataPoints = new ArrayList<AfrDataPoint>();
        for (int i = 0; i < 200; ++i) {
            dataPoints.add(AfrDataPoint.valueOf(14.7, 1500 + i, 50.0));
        }
        Result r = FuelAutoTune.INSTANCE.process(false, dataPoints, 0.1, 14.7, veTable);
        Assert.assertEquals(0L, this.countNotEqual(r.getKgbcRES(), value));
    }

    @Test
    public void testOptimizeOneCell() {
        double value = 0.7;
        double[][] veTable = FuelAutoTuneTest.createVeTable(value);
        ArrayList<AfrDataPoint> allSamePoints = new ArrayList<AfrDataPoint>();
        for (int i = 0; i < 200; ++i) {
            allSamePoints.add(AfrDataPoint.valueOf(10.0, 1500, 50.0));
        }
        Result r = FuelAutoTune.INSTANCE.process(false, allSamePoints, 0.1, 14.7, veTable);
        FuelAutoTuneTest.printNotDefault(r.getKgbcRES(), value);
        Assert.assertEquals(0.5, r.getKgbcRES()[6][3], 1.0E-5);
        Assert.assertEquals(1L, this.countNotEqual(r.getKgbcRES(), value));
    }

    private int countNotEqual(double[][] array2D, double value) {
        int result = 0;
        double[][] dArray = array2D;
        int n = dArray.length;
        for (int i = 0; i < n; ++i) {
            double[] array;
            for (double v : array = dArray[i]) {
                if (v == value) continue;
                ++result;
            }
        }
        return result;
    }

    @Test
    public void testAutoTune() {
        ArrayList<AfrDataPoint> dataPoints = new ArrayList<AfrDataPoint>();
        dataPoints.add(AfrDataPoint.valueOf(13.0, 1200, 80.0));
        Result r = FuelAutoTune.INSTANCE.process(false, dataPoints, 0.1, 13.0, FuelAutoTuneTest.createVeTable(1.0));
        FuelAutoTuneTest.printNotDefault(r.getKgbcRES(), 1.0);
        dataPoints.add(AfrDataPoint.valueOf(13.0, 1200, 80.0));
        dataPoints.add(AfrDataPoint.valueOf(14.0, 1300, 60.0));
        dataPoints.add(AfrDataPoint.valueOf(15.0, 1400, 70.0));
        dataPoints.add(AfrDataPoint.valueOf(16.0, 1500, 90.0));
        for (int i = 0; i < 2000; ++i) {
            dataPoints.add(AfrDataPoint.valueOf(16.0, 1500 + i, 90.0));
        }
        r = FuelAutoTune.INSTANCE.process(false, dataPoints, 0.01, 13.0, FuelAutoTuneTest.createVeTable(1.0));
        FuelAutoTuneTest.printNotDefault(r.getKgbcRES(), 1.0);
        for (int i = 0; i < 2000; ++i) {
            dataPoints.add(AfrDataPoint.valueOf(15.0, 1500 + i, 90.0));
        }
        r = FuelAutoTune.INSTANCE.process(false, dataPoints, 0.01, 13.0, FuelAutoTuneTest.createVeTable(1.0));
        FuelAutoTuneTest.printNotDefault(r.getKgbcRES(), 1.0);
    }

    static void printNotDefault(double[][] array, double defaultValue) {
        for (int i = 0; i < array.length; ++i) {
            FuelAutoTuneTest.printNotDefault(array[i], i, defaultValue);
        }
    }

    private static void printNotDefault(double[] array, int index, double defaultValue) {
        for (int i = 0; i < array.length; ++i) {
            if (array[i] == defaultValue) continue;
            System.out.println("Found value: x=" + index + " y=" + i + ": " + array[i]);
        }
    }

    static double[][] createVeTable(double value) {
        double[][] veMap = new double[16][16];
        MathUtil.setArray2D(veMap, value);
        return veMap;
    }
}

