/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.math3.stat.descriptive.moment.Mean;
import org.apache.commons.math3.stat.descriptive.moment.StandardDeviation;

public class AverageAngles {
    static String PRIMARY = "T_PRIMARY";
    static String SECONDARY = "T_SECONDARY";
    private int count;
    private static final int MAX_RPM_CHANGE = 20;
    private int rpmAtPrevChart;
    Map<Integer, List<AngleEvent>> angleData = new TreeMap<Integer, List<AngleEvent>>();

    public AverageAngles() {
        this.clear();
    }

    public String getReport() {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            this.printReport(new PrintStream(byteArrayOutputStream));
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        return byteArrayOutputStream.toString();
    }

    public void clear() {
        this.rpmAtPrevChart = -1;
        this.angleData.clear();
        this.count = 0;
    }

    public void add(int rpm, String line) {
        int i;
        if (this.rpmAtPrevChart != -1 && Math.abs(this.rpmAtPrevChart - rpm) > 20) {
            System.out.println("Skipping due to rpm change: was " + this.rpmAtPrevChart + " now " + rpm);
            this.rpmAtPrevChart = rpm;
            return;
        }
        ++this.count;
        this.rpmAtPrevChart = rpm;
        String[] v = line.split("\\|");
        System.out.println("rpm " + rpm + ": " + v.length + " values");
        ArrayList<AngleEvent> current = new ArrayList<AngleEvent>();
        for (i = 0; i < v.length / 2; ++i) {
            Double angle = Double.parseDouble(v[2 * i]);
            int signal = (int)Double.parseDouble(v[2 * i + 1]);
            if (Double.isNaN(angle)) {
                System.out.println("Skipping due to NaN");
                return;
            }
            current.add(new AngleEvent(angle, signal));
        }
        for (i = 0; i < current.size(); ++i) {
            List<AngleEvent> list = this.angleData.get(i);
            if (list == null) {
                list = new ArrayList<AngleEvent>();
                this.angleData.put(i, list);
            }
            list.add((AngleEvent)current.get(i));
        }
    }

    public void printReport(Appendable stream) throws IOException {
        ArrayList<AngleEvent> angles = new ArrayList<AngleEvent>();
        stream.append("Based on " + this.count + " charts\r\n");
        stream.append("index,average,stdev,diff\r\n");
        double prev = 0.0;
        for (Map.Entry<Integer, List<AngleEvent>> e : this.angleData.entrySet()) {
            int k = e.getKey();
            List<AngleEvent> v = e.getValue();
            double[] values = new double[v.size()];
            for (int i = 0; i < v.size(); ++i) {
                values[i] = v.get(i).getAngle();
            }
            Mean m = new Mean();
            double mean = m.evaluate(values);
            StandardDeviation sd = new StandardDeviation();
            double sdv = sd.evaluate(values, mean);
            angles.add(new AngleEvent(mean, v.get(0).signal));
            double diff = mean - prev;
            prev = mean;
            stream.append(k + "," + mean + "," + sdv + "," + diff + "\r\n");
        }
        if (this.angleData.isEmpty()) {
            return;
        }
        Double lastValue = ((AngleEvent)angles.get(angles.size() - 1)).angle;
        stream.append("Last value = " + lastValue + ", using it to offset...\r\n");
        double delta = 720.0 - lastValue;
        stream.append("And the " + angles.size() + " angles are:\r\n");
        for (AngleEvent v : angles) {
            stream.append(this.range720(delta + v.angle) + "\r\n");
        }
        stream.append("And the " + angles.size() + " lines of code are:\r\n");
        for (AngleEvent v : angles) {
            int ckpSignalType = v.signal / 1000;
            trigger_event_e event = trigger_event_e.values()[ckpSignalType];
            String signal = ckpSignalType % 2 == 0 ? "TV_FALL" : "TV_RISE";
            stream.append("s->addEvent2(" + this.range720(delta + v.angle) + ", " + event.channel + ", " + signal + " PASS_ENGINE_PARAMETER);\r\n");
        }
    }

    private double range720(double v) {
        while (v > 720.0) {
            v -= 702.0;
        }
        return v;
    }

    private static class AngleEvent {
        private final double angle;
        private final int signal;

        public AngleEvent(double angle, int signal) {
            this.angle = angle;
            this.signal = signal;
        }

        public double getAngle() {
            return this.angle;
        }
    }

    static enum trigger_event_e {
        SHAFT_PRIMARY_FALLING(PRIMARY),
        SHAFT_PRIMARY_RISING(PRIMARY),
        SHAFT_SECONDARY_FALLING(SECONDARY),
        SHAFT_SECONDARY_RISING(SECONDARY);

        private String channel;

        private trigger_event_e(String channel) {
            this.channel = channel;
        }
    }
}

