/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi.trigger;

import com.rusefi.VariableRegistry;
import com.rusefi.trigger.TriggerWheelInfo;

public class TriggerWheelTSLogic {
    private static final String TRIGGER_TYPE_WITHOUT_KNOWN_LOCATION = "TRIGGER_TYPE_WITHOUT_KNOWN_LOCATION";
    private static final String TRIGGER_TYPE_WITH_SECOND_WHEEL = "TRIGGER_TYPE_WITH_SECOND_WHEEL";
    private static final String TRIGGER_CRANK_BASED = "TRIGGER_CRANK_BASED";

    public static void main(String[] args) {
        VariableRegistry variableRegistry = new VariableRegistry();
        new TriggerWheelTSLogic().execute(TriggerWheelInfo.DEFAULT_WORK_FOLDER, variableRegistry);
    }

    public void execute(String folder, VariableRegistry variableRegistry) {
        if (folder == null) {
            System.out.println(this.getClass() + ": Folder not specified");
            return;
        }
        StringBuilder triggerTypesWithoutKnownLocation = new StringBuilder();
        StringBuilder triggerTypesWithSecondWheel = new StringBuilder();
        StringBuilder triggerTypesCrankBased = new StringBuilder();
        TriggerWheelInfo.readWheels(folder, wheelInfo -> {
            System.out.println("onWheel " + wheelInfo.getTriggerName());
            if (!wheelInfo.isHardcodedOperationMode()) {
                this.appendOrIfNotEmpty(triggerTypesWithoutKnownLocation);
                triggerTypesWithoutKnownLocation.append("trigger_type == ").append(wheelInfo.getId());
            }
            if (wheelInfo.isHasSecondChannel()) {
                this.appendOrIfNotEmpty(triggerTypesWithSecondWheel);
                triggerTypesWithSecondWheel.append("trigger_type == ").append(wheelInfo.getId());
            }
            if (wheelInfo.isCrankBased()) {
                this.appendOrIfNotEmpty(triggerTypesCrankBased);
                triggerTypesCrankBased.append("trigger_type == ").append(wheelInfo.getId());
            }
        });
        variableRegistry.register(TRIGGER_TYPE_WITHOUT_KNOWN_LOCATION, triggerTypesWithoutKnownLocation.toString());
        variableRegistry.register(TRIGGER_TYPE_WITH_SECOND_WHEEL, triggerTypesWithSecondWheel.toString());
        variableRegistry.register(TRIGGER_CRANK_BASED, triggerTypesCrankBased.toString());
    }

    private void appendOrIfNotEmpty(StringBuilder triggerTypesWithSecondWheel) {
        if (triggerTypesWithSecondWheel.length() > 0) {
            triggerTypesWithSecondWheel.append(" || ");
        }
    }
}

