/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi.core.ui;

import java.awt.Frame;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Arrays;
import javax.swing.JComponent;
import javax.swing.JFrame;

public class FrameHelper {
    private final JFrame frame = new JFrame();

    public FrameHelper() {
        this(2);
    }

    public FrameHelper(int operation) {
        this.frame.setDefaultCloseOperation(operation);
    }

    public JFrame getFrame() {
        return this.frame;
    }

    public void showFrame(JComponent component) {
        this.showFrame(component, true);
    }

    public void showFrame(JComponent component, boolean maximizeOnStart) {
        this.initFrame(component, maximizeOnStart);
        this.frame.setVisible(true);
    }

    public void initFrame(JComponent component, final boolean maximizeOnStart) {
        this.frame.setSize(800, 500);
        this.frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowOpened(WindowEvent e) {
                FrameHelper.this.onWindowOpened();
                if (maximizeOnStart) {
                    FrameHelper.this.frame.setExtendedState(FrameHelper.this.frame.getExtendedState() | 6);
                }
            }

            @Override
            public void windowClosed(WindowEvent ev) {
                FrameHelper.this.onWindowClosed();
                for (Thread t : Thread.getAllStackTraces().keySet()) {
                    if (t.isDaemon()) continue;
                    System.out.println("Non-daemon thread: " + t);
                }
                System.out.println(Arrays.toString(Frame.getFrames()));
            }
        });
        this.frame.add(component);
    }

    protected void onWindowOpened() {
    }

    protected void onWindowClosed() {
    }
}

