/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi.ui;

import com.opensr5.ConfigurationImage;
import com.opensr5.ini.IniFileModel;
import com.opensr5.ini.field.IniField;
import com.opensr5.io.ConfigurationImageFile;
import com.rusefi.binaryprotocol.MsqFactory;
import com.rusefi.tune.xml.Constant;
import com.rusefi.tune.xml.Msq;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;

@Ignore
public class TuneReadWriteTest {
    private static final String PATH = "src/test/resources/frankenso/";
    private static final String TEST_INI = "src/test/resources/frankenso/mainController.ini";
    private static final String TEST_BINARY_FILE = "src/test/resources/frankenso/current_configuration.rusefi_binary";
    private static final int LEGACY_TOTAL_CONFIG_SIZE = 20000;

    @Before
    public void before() {
        IniFileModel.getInstance().readIniFile(TEST_INI);
    }

    @Test
    public void testCompareBinaryToTSTune() throws Exception {
        Msq tsTune = Msq.readTune("src/test/resources/frankenso/CurrentTune.msq");
        System.out.println(tsTune);
        Assert.assertNotNull("signature", tsTune.getVersionInfo().getSignature());
        Constant flow = tsTune.findPage().findParameter("injector_flow");
        Assert.assertNotNull(flow);
        Assert.assertEquals("2", flow.getDigits());
        ConfigurationImage tsBinaryData = tsTune.asImage(IniFileModel.getInstance(), 20000);
        System.out.println("Reading src/test/resources/frankenso/current_configuration.rusefi_binary");
        ConfigurationImage fileBinaryData = ConfigurationImageFile.readFromFile(TEST_BINARY_FILE);
        int mismatchCounter = TuneReadWriteTest.compareImages(tsBinaryData, fileBinaryData);
        Assert.assertEquals(0L, mismatchCounter);
    }

    @Test
    public void testWriteAndReadTSTune() throws Exception {
        ConfigurationImage fileBinaryData = ConfigurationImageFile.readFromFile(TEST_BINARY_FILE);
        Path path = Files.createTempFile("unit_test_", ".xml", new FileAttribute[0]);
        String fileName = path.getFileName().toString();
        Msq tuneFromBinary = MsqFactory.valueOf(fileBinaryData);
        tuneFromBinary.writeXmlFile(fileName);
        Constant batteryCorrection = tuneFromBinary.findPage().findParameter("injector_battLagCorrBins");
        Assert.assertNotNull(batteryCorrection);
        Assert.assertEquals("2", batteryCorrection.getDigits());
        Constant flow = tuneFromBinary.findPage().findParameter("injector_flow");
        Assert.assertNotNull(flow);
        Assert.assertEquals("2", flow.getDigits());
        Constant nonEmptyFormula = tuneFromBinary.findPage().findParameter("fsioFormulas1");
        Assert.assertNotNull(nonEmptyFormula);
        Constant emptyFormula = tuneFromBinary.findPage().findParameter("fsioFormulas2");
        Assert.assertNull(emptyFormula);
        Constant enumField = tuneFromBinary.findPage().findParameter("acRelayPin");
        Assert.assertEquals("\"NONE\"", enumField.getValue());
        Msq tuneFromFile = Msq.readTune(fileName);
        Assert.assertNotNull(tuneFromFile.getVersionInfo().getSignature());
        ConfigurationImage binaryDataFromXml = tuneFromFile.asImage(IniFileModel.getInstance(), 20000);
        Assert.assertEquals(0L, TuneReadWriteTest.compareImages(binaryDataFromXml, fileBinaryData));
        Files.delete(path);
    }

    private static int compareImages(ConfigurationImage image1, ConfigurationImage fileData) {
        byte[] tsBinaryDataContent = image1.getContent();
        byte[] fileBinaryDataContent = fileData.getContent();
        int mismatchCounter = 0;
        for (int i = 0; i < tsBinaryDataContent.length; ++i) {
            byte tsByte = tsBinaryDataContent[i];
            byte fileByte = fileBinaryDataContent[i];
            if (tsByte == fileByte) continue;
            IniField field = IniFileModel.getInstance().findByOffset(i);
            System.out.println("Mismatch at offset=" + i + ", " + (field == null ? "(no field)" : field) + " runtime=" + tsByte + "/file=" + fileByte);
            ++mismatchCounter;
        }
        System.out.println("Total mismatch count " + mismatchCounter);
        return mismatchCounter;
    }
}

