/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi.livedata;

import com.rusefi.CodeWalkthrough;
import com.rusefi.config.Field;
import com.rusefi.enums.live_data_e;
import com.rusefi.ldmp.StateDictionary;
import com.rusefi.livedata.LiveDataParserPanel;
import com.rusefi.livedata.ParseResult;
import com.rusefi.ui.livedata.SourceCodePainter;
import com.rusefi.ui.livedata.VariableValueSource;
import java.io.IOException;
import java.net.URISyntaxException;
import org.antlr.v4.runtime.tree.ParseTree;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;

public class LiveDataConventionTest {
    @Test
    @Ignore
    public void assertLiveDataConvention() throws IOException, URISyntaxException {
        for (live_data_e view : live_data_e.values()) {
            String fileName = StateDictionary.INSTANCE.getFileName(view) + ".cpp";
            Field[] values = StateDictionary.INSTANCE.getFields(view);
            this.assertFile(fileName, values);
        }
    }

    private void assertFile(String fileName, Field[] values) throws IOException, URISyntaxException {
        VariableValueSource valueSource = name -> {
            Field f = Field.findFieldOrNull(values, "", name);
            if (f == null) {
                return null;
            }
            System.out.println("getValue");
            return new VariableValueSource.VariableState(null, 0.0);
        };
        String sourceCode = LiveDataParserPanel.getContent(LiveDataParserPanel.class, fileName);
        Assert.assertTrue("No content " + fileName + " size=" + sourceCode.length(), sourceCode.length() > 100);
        ParseTree tree = LiveDataParserPanel.getParseTree(sourceCode);
        ParseResult parseResult = CodeWalkthrough.applyVariables(valueSource, sourceCode, SourceCodePainter.VOID, tree);
        Assert.assertTrue("Broken live data constraint in " + fileName + ": " + parseResult.geBrokenConditions(), parseResult.geBrokenConditions().isEmpty());
    }
}

