/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi.io.stream;

import com.devexperts.logging.Logging;
import com.opensr5.io.DataListener;
import com.rusefi.binaryprotocol.IncomingDataBuffer;
import com.rusefi.io.IoStream;
import com.rusefi.io.can.IsoTpCanDecoder;
import com.rusefi.io.can.IsoTpConnector;
import com.rusefi.io.serial.AbstractIoStream;
import com.rusefi.io.serial.RateCounter;
import com.rusefi.io.tcp.BinaryProtocolServer;
import com.rusefi.ui.StatusConsumer;
import java.io.IOException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.jetbrains.annotations.Nullable;
import peak.can.basic.PCANBasic;
import peak.can.basic.TPCANBaudrate;
import peak.can.basic.TPCANHandle;
import peak.can.basic.TPCANMessageType;
import peak.can.basic.TPCANMsg;
import peak.can.basic.TPCANStatus;
import peak.can.basic.TPCANType;

public class PCanIoStream
extends AbstractIoStream {
    private static final int INFO_SKIP_RATE = 3;
    static Logging log = Logging.getLogging(PCanIoStream.class);
    public static final TPCANHandle CHANNEL = TPCANHandle.PCAN_USBBUS1;
    private final IncomingDataBuffer dataBuffer;
    private final PCANBasic can;
    private final StatusConsumer statusListener;
    private final RateCounter totalCounter = new RateCounter();
    private final RateCounter isoTpCounter = new RateCounter();
    private final IsoTpCanDecoder canDecoder = new IsoTpCanDecoder(){

        @Override
        protected void onTpFirstFrame() {
            PCanIoStream.this.sendCanPacket(1.FLOW_CONTROL);
        }
    };
    private final IsoTpConnector isoTpConnector = new IsoTpConnector(){

        @Override
        public void sendCanData(byte[] hdr, byte[] data, int dataOffset, int dataLength) {
            byte[] total = 2.combineArrays(hdr, data, dataOffset, dataLength);
            PCanIoStream.this.sendCanPacket(total);
        }

        @Override
        public void receiveData() {
        }
    };
    private int logSkipRate;

    @Nullable
    public static PCanIoStream createStream() {
        return PCanIoStream.createStream(message -> log.info(message));
    }

    public static PCanIoStream createStream(StatusConsumer statusListener) {
        PCANBasic can = new PCANBasic();
        can.initializeAPI();
        TPCANStatus status = can.Initialize(CHANNEL, TPCANBaudrate.PCAN_BAUD_500K, TPCANType.PCAN_TYPE_NONE, 0, (short)0);
        if (status != TPCANStatus.PCAN_ERROR_OK) {
            statusListener.append("Error initializing PCAN: " + (Object)((Object)status));
            return null;
        }
        statusListener.append("Creating PCAN stream...");
        return new PCanIoStream(can, statusListener);
    }

    private void sendCanPacket(byte[] payLoad) {
        TPCANMsg msg;
        TPCANStatus status;
        if (log.debugEnabled()) {
            log.debug("-------sendIsoTp " + payLoad.length + " byte(s):");
        }
        if (log.debugEnabled()) {
            log.debug("Sending " + IoStream.printHexBinary(payLoad));
        }
        if ((status = this.can.Write(CHANNEL, msg = new TPCANMsg(256, TPCANMessageType.PCAN_MESSAGE_STANDARD.getValue(), (byte)payLoad.length, payLoad))) != TPCANStatus.PCAN_ERROR_OK) {
            this.statusListener.append("Unable to write the CAN message: " + (Object)((Object)status));
            System.exit(0);
        }
    }

    private PCanIoStream(PCANBasic can, StatusConsumer statusListener) {
        this.can = can;
        this.statusListener = statusListener;
        this.dataBuffer = this.createDataBuffer("[PCAN] ");
    }

    @Override
    public void write(byte[] bytes) throws IOException {
        IsoTpConnector.sendStrategy(bytes, this.isoTpConnector);
    }

    @Override
    public void setInputListener(DataListener listener) {
        ExecutorService threadExecutor = Executors.newSingleThreadExecutor(BinaryProtocolServer.getThreadFactory("PCAN reader"));
        threadExecutor.execute(() -> {
            while (!this.isClosed()) {
                this.readOnePacket(listener);
            }
        });
    }

    private void readOnePacket(DataListener listener) {
        TPCANMsg rx = new TPCANMsg(127);
        TPCANStatus status = this.can.Read(CHANNEL, rx, null);
        if (status == TPCANStatus.PCAN_ERROR_OK) {
            this.totalCounter.add();
            if (rx.getID() != 258) {
                ++this.logSkipRate;
                if (this.logSkipRate % 3 == 0) {
                    this.debugPacket(rx);
                    log.info("Skipping non " + String.format("%X", 258) + " packet: " + String.format("%X", rx.getID()));
                    log.info("Total rate " + this.totalCounter.getCurrentRate() + ", isotp rate " + this.isoTpCounter.getCurrentRate());
                }
                return;
            }
            this.debugPacket(rx);
            this.isoTpCounter.add();
            byte[] decode = this.canDecoder.decodePacket(rx.getData());
            listener.onDataArrived(decode);
        }
    }

    private void debugPacket(TPCANMsg rx) {
        if (log.debugEnabled()) {
            log.debug("Got [" + rx + "] id=" + String.format("%X", rx.getID()) + " len=" + rx.getLength() + ": " + IoStream.printByteArray(rx.getData()));
        }
    }

    @Override
    public IncomingDataBuffer getDataBuffer() {
        return this.dataBuffer;
    }
}

