/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.steelseries.tools;

import eu.hansolo.steelseries.tools.Util;
import java.awt.Color;
import java.awt.Paint;
import java.awt.PaintContext;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.ColorModel;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public final class ContourGradientPaint
implements Paint {
    private static final Util UTIL = Util.INSTANCE;
    private final Rectangle2D BOUNDS;
    private final Float[] FRACTIONS;
    private final Color[] COLORS;
    private List<Color> colorLookup = new ArrayList<Color>(256);

    public ContourGradientPaint(Rectangle2D rectangle2D, float[] fArray, Color[] colorArray) throws IllegalArgumentException {
        this.BOUNDS = rectangle2D;
        if (fArray.length != colorArray.length) {
            throw new IllegalArgumentException("Fractions and colors must be equal in size");
        }
        ArrayList<Float> arrayList = new ArrayList<Float>(fArray.length);
        for (float f : fArray) {
            arrayList.add(Float.valueOf(f));
        }
        Object object = new ArrayList(colorArray.length);
        object.addAll(Arrays.asList(colorArray));
        if (((Float)arrayList.get(0)).floatValue() != 0.0f) {
            arrayList.add(0, Float.valueOf(0.0f));
            Color color = (Color)object.get(0);
            object.add(0, color);
        }
        if (((Float)arrayList.get(arrayList.size() - 1)).floatValue() != 1.0f) {
            arrayList.add(Float.valueOf(1.0f));
            object.add(colorArray[0]);
        }
        this.COLORS = new Color[object.size()];
        this.FRACTIONS = new Float[arrayList.size()];
        object.toArray(this.COLORS);
        arrayList.toArray(this.FRACTIONS);
        this.colorLookup.clear();
        this.colorLookup.addAll(this.prepareColorLookup());
    }

    private List<Color> prepareColorLookup() {
        int n = this.BOUNDS.getWidth() <= this.BOUNDS.getHeight() ? (int)(this.BOUNDS.getWidth() / 2.0) : (int)(this.BOUNDS.getHeight() / 2.0);
        ArrayList<Color> arrayList = new ArrayList<Color>(n);
        for (int i = 0; i < this.COLORS.length - 1; ++i) {
            int n2 = 0;
            for (int j = (int)(this.FRACTIONS[i].floatValue() * (float)n); j < (int)(this.FRACTIONS[i + 1].floatValue() * (float)n); ++j) {
                arrayList.add(UTIL.getColorFromFraction(this.COLORS[i], this.COLORS[i + 1], (int)((this.FRACTIONS[i + 1].floatValue() - this.FRACTIONS[i].floatValue()) * (float)n), n2));
                ++n2;
            }
        }
        return arrayList;
    }

    @Override
    public PaintContext createContext(ColorModel colorModel, Rectangle rectangle, Rectangle2D rectangle2D, AffineTransform affineTransform, RenderingHints renderingHints) {
        return new ContourGradientPaintContext();
    }

    @Override
    public int getTransparency() {
        return 3;
    }

    public String toString() {
        return "ContourGradientPaint";
    }

    private final class ContourGradientPaintContext
    implements PaintContext {
        private final Point2D P1;
        private final Point2D P2;
        final GeneralPath SECTOR_A = new GeneralPath();
        final GeneralPath SECTOR_B = new GeneralPath();
        final GeneralPath SECTOR_C = new GeneralPath();
        final GeneralPath SECTOR_D = new GeneralPath();

        public ContourGradientPaintContext() {
            if (ContourGradientPaint.this.BOUNDS.getWidth() > ContourGradientPaint.this.BOUNDS.getHeight()) {
                this.P1 = new Point2D.Double(ContourGradientPaint.this.BOUNDS.getX() + ContourGradientPaint.this.BOUNDS.getHeight() / 2.0, ContourGradientPaint.this.BOUNDS.getY() + ContourGradientPaint.this.BOUNDS.getHeight() / 2.0);
                this.P2 = new Point2D.Double(ContourGradientPaint.this.BOUNDS.getMaxX() - ContourGradientPaint.this.BOUNDS.getHeight() / 2.0, ContourGradientPaint.this.BOUNDS.getMinY() + ContourGradientPaint.this.BOUNDS.getHeight() / 2.0);
            } else if (ContourGradientPaint.this.BOUNDS.getWidth() < ContourGradientPaint.this.BOUNDS.getHeight()) {
                this.P1 = new Point2D.Double(ContourGradientPaint.this.BOUNDS.getX() + ContourGradientPaint.this.BOUNDS.getWidth() / 2.0, ContourGradientPaint.this.BOUNDS.getY() + ContourGradientPaint.this.BOUNDS.getWidth() / 2.0);
                this.P2 = new Point2D.Double(ContourGradientPaint.this.BOUNDS.getX() + ContourGradientPaint.this.BOUNDS.getWidth() / 2.0, ContourGradientPaint.this.BOUNDS.getMaxY() - ContourGradientPaint.this.BOUNDS.getWidth() / 2.0);
            } else {
                this.P2 = this.P1 = new Point2D.Double(ContourGradientPaint.this.BOUNDS.getX() + ContourGradientPaint.this.BOUNDS.getWidth() / 2.0, ContourGradientPaint.this.BOUNDS.getY() + ContourGradientPaint.this.BOUNDS.getHeight() / 2.0);
            }
            this.SECTOR_A.moveTo(ContourGradientPaint.this.BOUNDS.getMinX(), ContourGradientPaint.this.BOUNDS.getMaxY());
            this.SECTOR_A.lineTo(this.P1.getX(), this.P2.getY());
            this.SECTOR_A.lineTo(this.P1.getX(), this.P1.getY());
            this.SECTOR_A.lineTo(ContourGradientPaint.this.BOUNDS.getMinX(), ContourGradientPaint.this.BOUNDS.getMinY());
            this.SECTOR_A.closePath();
            this.SECTOR_B.moveTo(ContourGradientPaint.this.BOUNDS.getMinX(), ContourGradientPaint.this.BOUNDS.getMinY());
            this.SECTOR_B.lineTo(this.P1.getX(), this.P1.getY());
            this.SECTOR_B.lineTo(this.P2.getX(), this.P1.getY());
            this.SECTOR_B.lineTo(ContourGradientPaint.this.BOUNDS.getMaxX(), ContourGradientPaint.this.BOUNDS.getMinY());
            this.SECTOR_B.closePath();
            this.SECTOR_C.moveTo(ContourGradientPaint.this.BOUNDS.getMaxX(), ContourGradientPaint.this.BOUNDS.getMinY());
            this.SECTOR_C.lineTo(this.P2.getX(), this.P1.getY());
            this.SECTOR_C.lineTo(this.P2.getX(), this.P2.getY());
            this.SECTOR_C.lineTo(ContourGradientPaint.this.BOUNDS.getMaxX(), ContourGradientPaint.this.BOUNDS.getMaxY());
            this.SECTOR_C.closePath();
            this.SECTOR_D.moveTo(ContourGradientPaint.this.BOUNDS.getMaxX(), ContourGradientPaint.this.BOUNDS.getMaxY());
            this.SECTOR_D.lineTo(this.P2.getX(), this.P2.getY());
            this.SECTOR_D.lineTo(this.P1.getX(), this.P2.getY());
            this.SECTOR_D.lineTo(ContourGradientPaint.this.BOUNDS.getMinX(), ContourGradientPaint.this.BOUNDS.getMaxY());
            this.SECTOR_D.closePath();
        }

        @Override
        public void dispose() {
        }

        @Override
        public ColorModel getColorModel() {
            return ColorModel.getRGBdefault();
        }

        @Override
        public Raster getRaster(int n, int n2, int n3, int n4) {
            Point point = new Point(0, 0);
            WritableRaster writableRaster = this.getColorModel().createCompatibleWritableRaster(n3, n4);
            int[] nArray = new int[n3 * n4 * 4];
            Color color = new Color(0.0f, 0.0f, 0.0f, 0.0f);
            int n5 = 0;
            int n6 = 0;
            int n7 = 0;
            int n8 = 0;
            for (int i = 0; i < n4; ++i) {
                for (int j = 0; j < n3; ++j) {
                    point.setLocation(n + j, n2 + i);
                    if (this.SECTOR_A.contains(point) && n + j - ((ContourGradientPaint)ContourGradientPaint.this).BOUNDS.getBounds().x < ContourGradientPaint.this.colorLookup.size()) {
                        color = (Color)ContourGradientPaint.this.colorLookup.get(n + j - ((ContourGradientPaint)ContourGradientPaint.this).BOUNDS.getBounds().x);
                    }
                    if (this.SECTOR_B.contains(point) && n2 + i - ((ContourGradientPaint)ContourGradientPaint.this).BOUNDS.getBounds().y < ContourGradientPaint.this.colorLookup.size()) {
                        color = (Color)ContourGradientPaint.this.colorLookup.get(n2 + i - ((ContourGradientPaint)ContourGradientPaint.this).BOUNDS.getBounds().y);
                    }
                    if (this.SECTOR_C.contains(point) && ContourGradientPaint.this.colorLookup.size() - (n + j - this.SECTOR_A.getBounds().width - ((ContourGradientPaint)ContourGradientPaint.this).BOUNDS.getBounds().x - ((int)this.P2.getX() - (int)this.P1.getX())) < ContourGradientPaint.this.colorLookup.size()) {
                        color = (Color)ContourGradientPaint.this.colorLookup.get(ContourGradientPaint.this.colorLookup.size() - (n + j - this.SECTOR_A.getBounds().width - ((ContourGradientPaint)ContourGradientPaint.this).BOUNDS.getBounds().x - ((int)this.P2.getX() - (int)this.P1.getX())));
                    }
                    if (this.SECTOR_D.contains(point) && ContourGradientPaint.this.colorLookup.size() - (n2 + i - this.SECTOR_B.getBounds().height - ((ContourGradientPaint)ContourGradientPaint.this).BOUNDS.getBounds().y - ((int)this.P2.getY() - (int)this.P1.getY())) < ContourGradientPaint.this.colorLookup.size()) {
                        color = (Color)ContourGradientPaint.this.colorLookup.get(ContourGradientPaint.this.colorLookup.size() - (n2 + i - this.SECTOR_B.getBounds().height - ((ContourGradientPaint)ContourGradientPaint.this).BOUNDS.getBounds().y - ((int)this.P2.getY() - (int)this.P1.getY())));
                    }
                    n5 = color.getRed();
                    n6 = color.getGreen();
                    n7 = color.getBlue();
                    n8 = color.getAlpha();
                    int n9 = (i * n3 + j) * 4;
                    nArray[n9 + 0] = n5;
                    nArray[n9 + 1] = n6;
                    nArray[n9 + 2] = n7;
                    nArray[n9 + 3] = n8;
                }
            }
            writableRaster.setPixels(0, 0, n3, n4, nArray);
            return writableRaster;
        }
    }
}

