/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi.logic.test;

import com.rusefi.logic.IgnitionMapBuilder;
import junit.framework.Assert;
import org.junit.Test;

public class IgnitionMapBuilderTest {
    private static final double EPS = 0.001;

    @Test
    public void testIgnitionMapBuilder() {
        Assert.assertEquals(1.1, IgnitionMapBuilder.round10(1.1));
        Assert.assertEquals(1.1, IgnitionMapBuilder.round10(1.123));
        Assert.assertEquals(0.0, IgnitionMapBuilder.getBoreCorrection(101.6));
        Assert.assertEquals(6.0, IgnitionMapBuilder.getBoreCorrection(127.0), 0.001);
        Assert.assertEquals(35.0, IgnitionMapBuilder.getTopAdvanceForBore(IgnitionMapBuilder.ChamberStyle.OPEN_CHAMBER, 98, 8.0, 101.6));
        Assert.assertEquals(33.0, IgnitionMapBuilder.getTopAdvanceForBore(IgnitionMapBuilder.ChamberStyle.OPEN_CHAMBER, 98, 11.0, 101.6));
        Assert.assertEquals(22.0, IgnitionMapBuilder.getTopAdvanceForBore(IgnitionMapBuilder.ChamberStyle.SWIRL_TUMBLE, 89, 9.0, 101.6));
        Assert.assertEquals(32.2, IgnitionMapBuilder.getTopAdvanceForBore(IgnitionMapBuilder.ChamberStyle.SWIRL_TUMBLE, 89, 9.0, 145.0));
        Assert.assertEquals(10.0, IgnitionMapBuilder.interpolate(0.0, 10.0, 10.0, 20.0, 0.0));
        Assert.assertEquals(20.0, IgnitionMapBuilder.interpolate(0.0, 10.0, 10.0, 20.0, 10.0));
        Assert.assertEquals(10.0, IgnitionMapBuilder.getAdvanceForRpm(0, 36.0));
        Assert.assertEquals(10.0, IgnitionMapBuilder.getAdvanceForRpm(600, 36.0));
        Assert.assertEquals(36.0, IgnitionMapBuilder.getAdvanceForRpm(6500, 36.0));
        Assert.assertEquals(16.5, IgnitionMapBuilder.getAdvanceForRpm(1200, 36.0));
        Assert.assertEquals(29.5, IgnitionMapBuilder.getAdvanceForRpm(2400, 36.0));
        Assert.assertEquals(36.0, IgnitionMapBuilder.getInitialAdvance(6000, 100.0, 36.0));
        Assert.assertEquals(10.0, IgnitionMapBuilder.getInitialAdvance(600, 100.0, 36.0));
        Assert.assertEquals(44.0, IgnitionMapBuilder.getInitialAdvance(6000, 20.0, 36.0));
        Assert.assertEquals(34.3, IgnitionMapBuilder.getInitialAdvance(2400, 40.0, 36.0));
        Assert.assertEquals(42.0, IgnitionMapBuilder.getInitialAdvance(4400, 40.0, 36.0));
        Assert.assertEquals(11.6, IgnitionMapBuilder.getInitialAdvance(600, 20.0, 36.0));
    }
}

