/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi.config.test;

import com.opensr5.ConfigurationImage;
import com.rusefi.config.Field;
import com.rusefi.config.FieldCommandResponse;
import com.rusefi.config.generated.Fields;
import com.rusefi.core.Pair;
import org.junit.Assert;
import org.junit.Test;

public class FieldTest {
    @Test
    public void testParse() {
        Assert.assertNull(FieldCommandResponse.parseResponse("notint @768 is 21"));
        Pair<Integer, ?> p = FieldCommandResponse.parseResponse("int @768 is 21");
        Assert.assertNotNull(p);
        Assert.assertEquals(new Integer(768), p.first);
        Assert.assertEquals((Object)21, p.second);
        p = FieldCommandResponse.parseResponse("float @808 is 1.00");
        Assert.assertNotNull(p);
        Assert.assertEquals(new Integer(808), p.first);
        Assert.assertEquals((Object)1.0, p.second);
    }

    @Test
    public void setBooleanValue() {
        byte[] config = new byte[26368];
        ConfigurationImage ci = new ConfigurationImage(config);
        Assert.assertFalse(Fields.ISFORCEDINDUCTION.getBooleanValue(ci));
        Assert.assertFalse(Fields.OVERRIDETRIGGERGAPS.getBooleanValue(ci));
        Assert.assertFalse(Fields.ENABLEFAN1WITHAC.getBooleanValue(ci));
        Fields.OVERRIDETRIGGERGAPS.setValue(config, true);
        Assert.assertFalse(Fields.ISFORCEDINDUCTION.getBooleanValue(ci));
        Assert.assertTrue(Fields.OVERRIDETRIGGERGAPS.getBooleanValue(ci));
        Assert.assertFalse(Fields.ENABLEFAN1WITHAC.getBooleanValue(ci));
        Fields.OVERRIDETRIGGERGAPS.setValue(config, false);
        Assert.assertFalse(Fields.ISFORCEDINDUCTION.getBooleanValue(ci));
        Assert.assertFalse(Fields.OVERRIDETRIGGERGAPS.getBooleanValue(ci));
        Assert.assertFalse(Fields.ENABLEFAN1WITHAC.getBooleanValue(ci));
    }

    @Test
    public void testPrecisionDependingOnScale() {
        Assert.assertEquals("0.12302", Field.niceToString(0.12302, 4));
        Assert.assertEquals("0.1232", Field.niceToString(0.12317, 3));
        Assert.assertEquals("1234567.1", Field.niceToString(1234567.123, 4));
        Assert.assertEquals("10000.0", Field.niceToString(10000.00002, 4));
        Assert.assertEquals("0.002", Field.niceToString(0.002, 4));
        Assert.assertEquals("12.302", Field.niceToString(12.302, 4));
        Assert.assertEquals("12.302", Field.niceToString(12.302, 3));
        Assert.assertEquals("12.31", Field.niceToString(12.312, 2));
        Assert.assertEquals("123.02", Field.niceToString(123.02, 4));
    }
}

