/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi.ui.etb;

import com.rusefi.etb.EtbTarget;
import com.rusefi.etb.StandardTestSequence;
import com.rusefi.etb.TestSequenceStep;
import com.rusefi.ui.UIContext;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.atomic.AtomicInteger;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;

public class EtbTestSequence {
    protected static final ScheduledExecutorService executor = Executors.newSingleThreadScheduledExecutor();
    public static final int durationSeconds = 300;
    public static final int frequencyHz = 100;
    public static final int PAST_DEPTH = 20;
    private static final String BUTTON_TEXT = "Measure Control Quality";
    private final JButton button = new JButton("Measure Control Quality");
    private final JLabel result = new JLabel("Result: N/A");
    private final JButton cancelButton = new JButton("Cancel");
    private boolean isCancelled;

    public EtbTestSequence(UIContext uiContext) {
        this.cancelButton.setEnabled(false);
        this.button.addActionListener(e -> {
            this.isCancelled = false;
            this.button.setEnabled(false);
            this.cancelButton.setEnabled(true);
            StandardTestSequence.metric.start(30000, 10);
            AtomicInteger stepCounter = new AtomicInteger();
            AtomicInteger totalSteps = new AtomicInteger();
            TestSequenceStep lastStep = new TestSequenceStep(1000L, TestSequenceStep.Condition.YES){

                @Override
                protected void doJob() {
                    EtbTestSequence.this.endTestSequence();
                }
            };
            Runnable onEachStep = () -> SwingUtilities.invokeLater(() -> {
                String state = stepCounter.incrementAndGet() + "/" + totalSteps.get();
                this.button.setText("Running " + state);
                double value = StandardTestSequence.metric.getStandardDeviation();
                this.result.setText(String.format(state + " Result: %.3f", value));
            });
            EtbTarget firstStep = new EtbTarget(uiContext, 10000L, 4.0, onEachStep, TestSequenceStep.Condition.YES);
            TestSequenceStep result = StandardTestSequence.addSequence(uiContext, firstStep, onEachStep, new TestSequenceStep.Condition(){

                @Override
                public boolean shouldRunTask() {
                    if (EtbTestSequence.this.isCancelled) {
                        EtbTestSequence.this.endTestSequence();
                    }
                    return !EtbTestSequence.this.isCancelled;
                }
            });
            result.addNext(lastStep);
            totalSteps.set(TestSequenceStep.count(firstStep));
            firstStep.execute(executor);
        });
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EtbTestSequence.this.isCancelled = true;
                EtbTestSequence.this.cancelButton.setEnabled(false);
            }
        });
    }

    private void endTestSequence() {
        this.button.setEnabled(true);
        this.cancelButton.setEnabled(false);
        this.button.setText(BUTTON_TEXT);
        double finalValue = StandardTestSequence.metric.getStandardDeviation();
        this.result.setText(String.format("Final Result: %.3f", finalValue));
    }

    public JButton getButton() {
        return this.button;
    }

    public JLabel getResult() {
        return this.result;
    }

    public JComponent getCancelButton() {
        return this.cancelButton;
    }
}

