/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi.tools.tune;

import com.opensr5.ini.IniFileModel;
import com.opensr5.ini.field.ArrayIniField;
import com.rusefi.tools.tune.CurveData;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Arrays;
import java.util.Date;

public class TS2C {
    static final String FINGER_PRINT = "/* Generated by " + TS2C.class.getSimpleName() + " on " + new Date() + "*/\r\n";
    private int size;
    private CurveData loadBins;
    private CurveData rpmBins;

    public static void main(String[] args) throws IOException {
        new TS2C(args);
    }

    private TS2C(String[] args) throws IOException {
        System.out.println("This tool reads TS tune file and produces some C code for hardcoded base tunes");
        if (args.length != 3 && args.length != 4 && args.length != 5) {
            System.out.println("Three parameters expected: ");
            System.out.println("  INPUT_MSQ_FILE NAME LOAD_SECTION_NAME RPM_SECTION_NAME [TABLE_NAME]");
            System.out.println("for example");
            System.out.println("  currenttune.msq veLoadBins veRpmBins veTable");
            System.exit(-1);
        }
        String msqFileName = args[0];
        String loadSectionName = args[1];
        String rpmSectionName = args[2];
        String tableName = args.length == 3 ? "none" : args[3];
        IniFileModel model = IniFileModel.getInstance();
        String methodName = tableName.equalsIgnoreCase("none") ? loadSectionName : tableName;
        methodName = methodName.toUpperCase().substring(0, 1) + methodName.substring(1);
        BufferedWriter w = new BufferedWriter(new FileWriter("generated_" + methodName + ".cpp"));
        if (!loadSectionName.equalsIgnoreCase("none")) {
            this.loadBins = CurveData.processCurve(msqFileName, loadSectionName, model, w);
        }
        if (!rpmSectionName.equalsIgnoreCase("none")) {
            this.rpmBins = CurveData.processCurve(msqFileName, rpmSectionName, model, w);
        }
        if (!tableName.equalsIgnoreCase("none")) {
            ArrayIniField field = (ArrayIniField)model.allIniFields.get(tableName);
            if (field.getRows() != field.getCols()) {
                throw new UnsupportedOperationException("Not square table not supported yet");
            }
            this.size = field.getRows();
            float[][] table = new float[this.size][];
            for (int i = 0; i < this.size; ++i) {
                table[i] = new float[this.size];
            }
            BufferedReader r = TS2C.readAndScroll(msqFileName, tableName);
            this.readTable(table, r);
            w.write("static const float hardCoded" + tableName + "[" + this.size + "][" + this.size + "] = {\n");
            this.writeTable(w, (loadIndex, rpmIndex) -> table[loadIndex][rpmIndex]);
            w.write("};\n\n");
        }
        w.write(FINGER_PRINT);
        w.write("static void set" + methodName + "() {\n");
        w.write("\tMEMCPY(config->" + loadSectionName + ", hardCoded" + loadSectionName + ");\n");
        w.write("\tMEMCPY(config->" + rpmSectionName + ", hardCoded" + rpmSectionName + ");\n");
        if (!tableName.equalsIgnoreCase("none")) {
            w.write("\tMEMCPY(config->" + tableName + ", hardCoded" + tableName + ");\n");
        }
        w.write("}\n");
        w.close();
    }

    private void writeTable(BufferedWriter w, ValueSource valueSource) throws IOException {
        w.write(FINGER_PRINT);
        for (int loadIndex = 0; loadIndex < this.loadBins.getRawData().length; ++loadIndex) {
            this.writeTableLine(valueSource, w, loadIndex);
        }
    }

    static BufferedReader readAndScroll(String fileName, String magicStringKey) throws IOException {
        String line;
        BufferedReader reader = new BufferedReader(new FileReader(fileName));
        System.out.println("Reading from " + fileName + ", scrolling to " + magicStringKey);
        while ((line = reader.readLine()) != null) {
            if (!line.contains(magicStringKey)) continue;
            System.out.println("Found " + line);
            break;
        }
        return reader;
    }

    private void writeTableLine(ValueSource valueSource, BufferedWriter w, int loadIndex) throws IOException {
        StringBuilder sb = new StringBuilder("{");
        sb.append("/* " + loadIndex + " " + String.format("%3.3f", Float.valueOf(this.loadBins.getRawData()[loadIndex])) + "\t*/");
        for (int rpmIndex = 0; rpmIndex < this.rpmBins.getRawData().length; ++rpmIndex) {
            sb.append("/* " + rpmIndex + " " + this.rpmBins.getRawData()[rpmIndex] + "*/" + String.format("%3.3f", Float.valueOf(valueSource.getValue(loadIndex, rpmIndex))) + ",\t");
        }
        sb.append("},\r\n");
        w.write(sb.toString());
    }

    private void readTable(float[][] table, BufferedReader r) throws IOException {
        int index = 0;
        while (index < this.size) {
            String line = r.readLine();
            if (line == null) {
                throw new IOException("End of file?");
            }
            if ((line = line.trim()).isEmpty()) continue;
            Object[] values = line.split("\\s");
            if (values.length != this.size) {
                throw new IllegalStateException("Expected " + this.size + " but got " + Arrays.toString(values) + ". Unexpected line: " + line);
            }
            for (int i = 0; i < this.size; ++i) {
                String str = values[i];
                try {
                    table[index][i] = Float.parseFloat(str);
                    continue;
                }
                catch (NumberFormatException e) {
                    throw new IllegalStateException("While reading " + str, e);
                }
            }
            System.out.println("Got line " + index + ": " + Arrays.toString(table[index]));
            ++index;
        }
    }

    static interface ValueSource {
        public float getValue(int var1, int var2);
    }
}

