/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi.ui.util;

import com.rusefi.core.ui.AutoupdateUtil;
import com.rusefi.ui.util.LocalizedMessages;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import javax.imageio.ImageIO;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileNameExtensionFilter;
import javax.swing.text.JTextComponent;
import org.jetbrains.annotations.NotNull;

public class UiUtils {
    private static final String SAVE_IMAGE = "save image";

    public static void saveImageWithPrompt(String fileName, Component parentForDialog, Component content) {
        JFileChooser fc = UiUtils.getFileChooser(new FileNameExtensionFilter("PNG files", "png"));
        fc.setSelectedFile(new File(fileName));
        if (fc.showSaveDialog(parentForDialog) == 0) {
            fileName = fc.getSelectedFile().getAbsolutePath();
            UiUtils.saveImage(fileName, content);
        }
    }

    @NotNull
    public static JFileChooser getFileChooser(FileNameExtensionFilter filter) {
        JFileChooser fc = new JFileChooser();
        fc.setFileFilter(filter);
        fc.addChoosableFileFilter(filter);
        return fc;
    }

    public static void saveImage(String fileName, Component component) {
        BufferedImage img = UiUtils.getScreenShot(component);
        System.out.println("Saving " + fileName);
        try {
            ImageIO.write((RenderedImage)img, "png", new File(fileName));
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    private static BufferedImage getScreenShot(Component component) {
        AutoupdateUtil.assertAwtThread();
        BufferedImage image = new BufferedImage(component.getWidth(), component.getHeight(), 1);
        component.paint(image.getGraphics());
        return image;
    }

    public static void setPauseButtonText(JButton pauseButton, boolean isPaused) {
        UiUtils.setPauseButtonText(pauseButton, isPaused, "");
    }

    public static void setPauseButtonText(JButton pauseButton, boolean isPaused, String suffix) {
        pauseButton.setText((isPaused ? LocalizedMessages.RESUME.getMessage() : LocalizedMessages.PAUSE.getMessage()) + suffix);
    }

    public static void centerWindow(Window w) {
        w.pack();
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension frameSize = w.getSize();
        w.setLocation((screenSize.width - frameSize.width) / 2, (screenSize.height - frameSize.height) / 2);
    }

    public static void trueRepaint(JComponent control) {
        UiUtils.trueLayout(control);
    }

    public static void trueLayout(Component component) {
        AutoupdateUtil.trueLayout(component);
    }

    public static List<Component> getAllComponents(Container c) {
        Component[] comps = c.getComponents();
        ArrayList<Component> compList = new ArrayList<Component>();
        for (Component comp : comps) {
            compList.add(comp);
            if (!(comp instanceof Container)) continue;
            compList.addAll(UiUtils.getAllComponents((Container)comp));
        }
        return compList;
    }

    public static void setToolTip(JComponent component, String ... lines) {
        StringBuilder sb = new StringBuilder();
        for (String line : lines) {
            if (sb.length() != 0) {
                sb.append("<br>");
            }
            sb.append(line);
        }
        component.setToolTipText("<html>" + sb + "</html>");
    }

    public static JComponent wrap(JComponent component) {
        return AutoupdateUtil.wrap(component);
    }

    public static JButton createSaveImageButton() {
        JButton imageButton = new JButton(SAVE_IMAGE);
        imageButton.setMnemonic('s');
        return imageButton;
    }

    public static void invokeAndWait(Runnable runnable) throws InterruptedException, InvocationTargetException {
        if (SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else {
            SwingUtilities.invokeAndWait(runnable);
        }
    }

    public static void showLoadingMessage(JPanel panel) {
        panel.add((Component)new JLabel("Loading..."), "Center");
    }

    @NotNull
    public static JButton createPauseButton() {
        return UiUtils.createPauseButton("");
    }

    @NotNull
    public static JButton createPauseButton(String suffix) {
        JButton pauseButton = new JButton(LocalizedMessages.PAUSE.getMessage() + suffix);
        pauseButton.setMnemonic('p');
        return pauseButton;
    }

    @NotNull
    public static JButton createClearButton() {
        JButton clearButton = new JButton(LocalizedMessages.CLEAR.getMessage());
        clearButton.setMnemonic('c');
        return clearButton;
    }

    public static void installPopupMenu(final JPopupMenu menu, JComponent component) {
        component.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                this.pop(e);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                this.pop(e);
            }

            private void pop(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    menu.show(e.getComponent(), e.getX(), e.getY());
                }
            }
        });
    }

    @NotNull
    public static JMenuItem createCopyMenu(final JTextComponent control) {
        JMenuItem copy = new JMenuItem("Copy");
        copy.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                control.copy();
            }
        });
        return copy;
    }
}

