/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi.etb;

import com.rusefi.CyclicBuffer;
import com.rusefi.DataBuffer;
import com.rusefi.NamedThreadFactory;
import com.rusefi.core.Sensor;
import com.rusefi.core.SensorCentral;
import com.rusefi.core.ValueSource;
import java.util.Objects;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

public class ClosedLoopControlQualityMetric {
    private final ScheduledExecutorService executor = Executors.newSingleThreadScheduledExecutor(new NamedThreadFactory(ClosedLoopControlQualityMetric.class.getSimpleName()));
    private final int delayDepth;
    private final ValueSource target;
    private final ValueSource result;
    private final Sensor destination;
    private boolean isStarted;
    private DataBuffer errorsBuffer;
    private CyclicBuffer targetBuffer;

    public ClosedLoopControlQualityMetric(ValueSource target, ValueSource result, Sensor destination, int delayDepth) {
        this.target = target;
        this.result = result;
        this.destination = destination;
        this.delayDepth = delayDepth;
    }

    public void start(int bufferSize, int periodMs) {
        if (this.isStarted) {
            return;
        }
        this.isStarted = true;
        this.create(bufferSize);
        this.executor.scheduleAtFixedRate(() -> {
            this.add();
            SensorCentral.getInstance().setValue(this.getStandardDeviation(), this.destination);
        }, 0L, periodMs, TimeUnit.MILLISECONDS);
    }

    public void add() {
        double targetValue = this.target.getValue();
        double resultValue = this.result.getValue();
        double error = Math.abs(targetValue - resultValue);
        int pointer = this.targetBuffer.getPointer();
        for (int i = 0; i < Math.min(this.delayDepth - 1, this.targetBuffer.getSize()); ++i) {
            double thisError = Math.abs(this.targetBuffer.get(pointer - i) - resultValue);
            error = Math.min(error, thisError);
        }
        this.rememberCurrentError(error, targetValue);
    }

    public void create(int bufferSize) {
        this.errorsBuffer = new CyclicBuffer(bufferSize);
        this.targetBuffer = new CyclicBuffer(this.delayDepth);
    }

    public synchronized void reset() {
        this.errorsBuffer.clear();
    }

    public synchronized double getStandardDeviation() {
        return DataBuffer.getStandardDeviation(this.errorsBuffer.getValues());
    }

    private synchronized void rememberCurrentError(double error, double targetValue) {
        Objects.requireNonNull(this.errorsBuffer, "errorsBuffer");
        this.errorsBuffer.add(error);
        this.targetBuffer.add(targetValue);
    }
}

