/*
 * Decompiled with CFR 0.152.
 */
package com.opensr5.ini.test;

import com.opensr5.ini.IniFileMetaInfo;
import com.opensr5.ini.IniFileModel;
import com.opensr5.ini.IniFileReader;
import com.opensr5.ini.ProtocolCommand;
import com.opensr5.ini.RawIniFile;
import com.opensr5.ini.field.ArrayIniField;
import com.opensr5.ini.field.EnumIniField;
import com.opensr5.ini.field.IniField;
import java.io.ByteArrayInputStream;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;
import org.junit.Assert;
import org.junit.Test;

public class IniFileReaderTest {
    private static final String PAGE_READ = "    pageReadCommand     = \"X\",       \"X\",     \"X\"\n\n\n\n";
    private static final String SIGNATURE_UNIT_TEST = "  signature      = \"unit test\"\n";
    private static final double EPS = 1.0E-5;

    @Test
    public void parseExpressions() {
        Assert.assertEquals(0.1, IniField.parseDouble("{1/10}"), 1.0E-5);
        Assert.assertEquals(0.1, IniField.parseDouble("{0.1}"), 1.0E-5);
        Assert.assertEquals(0.1, IniField.parseDouble("0.1"), 1.0E-5);
    }

    @Test
    public void testSplitWithEmptyUnits() {
        String[] s = IniFileReader.splitTokens("\tverboseCanBaseAddress\t\t\t= \"\", 1");
        Assert.assertEquals(3L, s.length);
        Assert.assertEquals("", s[1]);
        s = IniFileReader.splitTokens("\tverboseCanBaseAddress\t\t\t= scalar, U32,\t756,\t\"\", 1, 0, 0, 536870911, 0");
        Assert.assertEquals(10L, s.length);
    }

    @Test
    public void testSplit() {
        String[] s = IniFileReader.splitTokens("1");
        Assert.assertEquals(s.length, 1L);
        Assert.assertEquals("1", s[0]);
        s = IniFileReader.splitTokens("hello");
        Assert.assertEquals(s.length, 1L);
        Assert.assertEquals("hello", s[0]);
        s = IniFileReader.splitTokens("\"hello\"");
        Assert.assertEquals(s.length, 1L);
        Assert.assertEquals("hello", s[0]);
        s = IniFileReader.splitTokens("\"hello\",\"w\"");
        Assert.assertEquals(s.length, 2L);
        Assert.assertEquals("hello", s[0]);
        Assert.assertEquals("w", s[1]);
    }

    @Test
    public void testQuotedTokens() {
        String[] result = IniFileReader.splitTokens("\"hel  lo\"");
        Assert.assertEquals(result.length, 1L);
        Assert.assertEquals("hel  lo", result[0]);
    }

    @Test
    public void testRealLine() {
        String[] result = IniFileReader.splitTokens("\tdialog = engineChars,\t\"Base Engine Settings\"");
        Assert.assertEquals(result.length, 3L);
        Assert.assertEquals("dialog", result[0]);
        Assert.assertEquals("engineChars", result[1]);
        Assert.assertEquals("Base Engine Settings", result[2]);
    }

    @Test
    public void testTotalPagesSize() {
        String string = "   nPages              = 3\n  signature      = \"unit test\"\n    pageReadCommand     = \"X\",       \"X\",     \"X\"\n\n\n\n   pageSize            = 288,   64,     288\n";
        IniFileMetaInfo meta = new IniFileMetaInfo(this.fromString(string));
        Assert.assertEquals(3L, meta.getnPages());
        Assert.assertEquals(16000L, meta.getBlockingFactor());
        Assert.assertEquals(640L, meta.getTotalSize());
        Assert.assertEquals("unit test", meta.getSignature());
        Assert.assertEquals(64L, meta.getPageSize(1));
        Assert.assertEquals("X", meta.getPageReadCommand(1));
    }

    @NotNull
    private RawIniFile fromString(String string) {
        return IniFileReader.read(new ByteArrayInputStream(string.getBytes()));
    }

    @Test
    public void testConditional() {
        String string = "page = 1\n[Constants]\n#if LAMBDA\n\tlambdaTable\t\t\t\t\t = array, U08, 18592, [16x16],\"deg\", 0.006802721088435374, 0, 0.6, 1.5, 2\n#else\n\tlambdaTable\t\t\t\t\t = array, U08, 18592, [16x16],\"deg\", 0.1, 0, 0, 25.0, 1\n#endif\n";
        RawIniFile lines = IniFileReader.read(new ByteArrayInputStream(string.getBytes()));
        IniFileModel model = new IniFileModel().readIniFile(lines);
        Assert.assertEquals(1L, model.allIniFields.size());
    }

    @Test
    public void testProtocolMeta() {
        String string = "[Constants]\n   crc32CheckCommand   = \"k\\x00\\x00\\x00\\x00\\x00\\x00\"\npage = 1\nprimingSquirtDurationMs\t\t\t= scalar, F32,\t96,\t\"*C\", 1.0, 0, -40, 200, 1\n";
        RawIniFile lines = IniFileReader.read(new ByteArrayInputStream(string.getBytes()));
        IniFileModel model = new IniFileModel().readIniFile(lines);
        Assert.assertEquals(1L, model.allIniFields.size());
        String crcProtocol = model.protocolMeta.get("crc32CheckCommand");
        Assert.assertEquals("k\\x00\\x00\\x00\\x00\\x00\\x00", crcProtocol);
        byte[] expected = new byte[]{107, 0, 0, 0, 0, 0, 0};
        Assert.assertTrue(Arrays.equals(expected, ProtocolCommand.parse(crcProtocol).getBytes()));
    }

    @Test
    public void testEasyFields() {
        String string = "page = 1\n[Constants]\nprimingSquirtDurationMs\t\t\t= scalar, F32,\t96,\t\"*C\", 1, 0, -40, 200, 1\n\tiat_adcChannel\t\t\t\t = bits, U08, 312, [0:7] \"PA0\", \"PA1\", \"PA2\", \"PA3\", \"PA4\", \"PA5\", \"PA6\", \"PA7\", \"PB0\", \"PB1\", \"PC0\", \"PC1\", \"PC2\", \"PC3\", \"PC4\", \"PC5\", \"Disabled\", \"PB12\", \"PB13\", \"PC14\", \"PC15\", \"PC16\", \"PC17\", \"PD3\", \"PD4\", \"PE2\", \"PE6\", \"INVALID\", \"INVALID\", \"INVALID\", \"INVALID\", \"INVALID\"\n";
        RawIniFile lines = IniFileReader.read(new ByteArrayInputStream(string.getBytes()));
        IniFileModel model = new IniFileModel().readIniFile(lines);
        Assert.assertEquals(2L, model.allIniFields.size());
    }

    @Test
    public void testSetBits() {
        Assert.assertEquals(254L, EnumIniField.setBitRange(255, 0, 0, 1));
        Assert.assertEquals(240L, EnumIniField.setBitRange(255, 0, 0, 4));
        Assert.assertEquals(15L, EnumIniField.setBitRange(255, 0, 4, 4));
        Assert.assertEquals(255L, EnumIniField.setBitRange(255, 3, 0, 2));
        Assert.assertEquals(243L, EnumIniField.setBitRange(255, 3, 0, 4));
        Assert.assertEquals(63L, EnumIniField.setBitRange(255, 3, 4, 4));
        Assert.assertEquals(1024L, EnumIniField.setBitRange(0, 1, 10, 1));
    }

    @Test
    public void testBitLogic() {
        Assert.assertEquals(4L, EnumIniField.getBitRange(4, 0, 8));
        Assert.assertEquals(4L, EnumIniField.getBitRange(4, 0, 3));
        Assert.assertEquals(0L, EnumIniField.getBitRange(4, 0, 2));
        Assert.assertEquals(3L, EnumIniField.getBitRange(7, 0, 2));
        Assert.assertEquals(true, EnumIniField.getBit(255, 0));
        Assert.assertEquals(true, EnumIniField.getBit(240, 4));
        Assert.assertEquals(2L, EnumIniField.getBitRange(240, 3, 2));
    }

    @Test
    public void testBitField() {
        String string = "page = 1\n[Constants]\n\tname\t= bits,    U32,   \t744, [3:5], \"false\", \"true\"";
        RawIniFile lines = IniFileReader.read(new ByteArrayInputStream(string.getBytes()));
        IniFileModel model = new IniFileModel().readIniFile(lines);
        Assert.assertEquals(1L, model.allIniFields.size());
        EnumIniField field = (EnumIniField)model.allIniFields.get("name");
        Assert.assertEquals(3L, field.getBitPosition());
        Assert.assertEquals(2L, field.getBitSize0());
        Assert.assertEquals(2L, field.getEnums().size());
    }

    @Test
    public void testCurveField() {
        String string = "page = 1\n \tname2\t\t\t= array, F32,\t108,\t[8],\t\"\", 1, 0, 0.0, 18000, 2\n[Constants]\n \tname\t\t\t= array, F32,\t108,\t[8],\t\"\", 1, 0, 0.0, 18000, 2\n[PcVariables]\n \tname3\t\t\t= array, F32,\t108,\t[8],\t\"\", 1, 0, 0.0, 18000, 2\n";
        RawIniFile lines = IniFileReader.read(new ByteArrayInputStream(string.getBytes()));
        IniFileModel model = new IniFileModel().readIniFile(lines);
        Assert.assertEquals(1L, model.allIniFields.size());
        ArrayIniField field = (ArrayIniField)model.allIniFields.get("name");
        Assert.assertNotNull(field);
        Assert.assertEquals(1L, field.getCols());
        Assert.assertEquals(8L, field.getRows());
    }

    @Test
    public void testDirectives() {
        String string = "page = 1\n[Constants]\n#if LAMBDA\n\tname\t= bits,    U32,   \t744, [0:2], \"false\"\n#else\n\tname\t= bits,    U32,   \t744, [3:4], \"false\", \"true\"\n#endif";
        RawIniFile lines = IniFileReader.read(new ByteArrayInputStream(string.getBytes()));
        IniFileModel model = new IniFileModel().readIniFile(lines);
        Assert.assertEquals(1L, model.allIniFields.size());
        EnumIniField field = (EnumIniField)model.allIniFields.get("name");
        Assert.assertEquals(3L, field.getBitPosition());
        Assert.assertEquals(1L, field.getBitSize0());
        Assert.assertEquals(2L, field.getEnums().size());
    }
}

