/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.steelseries.extras;

import eu.hansolo.steelseries.gauges.AbstractGauge;
import eu.hansolo.steelseries.gauges.AbstractRadial;
import eu.hansolo.steelseries.tools.LcdColor;
import eu.hansolo.steelseries.tools.PostPosition;
import eu.hansolo.steelseries.tools.Section;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.LinearGradientPaint;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import org.pushingpixels.trident.Timeline;
import org.pushingpixels.trident.ease.Spline;

public final class Altimeter
extends AbstractRadial {
    private double value100 = 0.0;
    private double oldValue = 0.0;
    private double value1000 = 0.0;
    private double value10000 = 0.0;
    private double angleStep100ft;
    private double angleStep1000ft;
    private double angleStep10000ft;
    private static final double TICKMARK_OFFSET = Math.PI;
    private float tickLabelPeriod = 1.0f;
    private final Point2D CENTER = new Point2D.Double();
    private BufferedImage bImage;
    private BufferedImage fImage;
    private BufferedImage pointer10000FtImage;
    private BufferedImage pointer1000FtImage;
    private BufferedImage pointer100FtImage;
    private BufferedImage disabledImage;
    private final Rectangle2D LCD = new Rectangle2D.Double();
    private Timeline timeline = new Timeline(this);
    private final FontRenderContext RENDER_CONTEXT = new FontRenderContext(null, true, true);
    private TextLayout unitLayout;
    private final Rectangle2D UNIT_BOUNDARY = new Rectangle2D.Double();
    private double unitStringWidth;
    private TextLayout valueLayout;
    private final Rectangle2D VALUE_BOUNDARY = new Rectangle2D.Double();
    private TextLayout infoLayout;
    private final Rectangle2D INFO_BOUNDARY = new Rectangle2D.Double();

    public Altimeter() {
        this.init(this.getInnerBounds().width, this.getInnerBounds().height);
        this.setMinValue(0.0);
        this.setMaxValue(10.0);
        this.calcAngleStep();
        this.setLcdColor(LcdColor.BLACK_LCD);
        this.setLcdVisible(true);
        this.setTitle("ALT");
        this.setUnitString("ft");
    }

    @Override
    public AbstractGauge init(int n, int n2) {
        int n3;
        int n4 = this.isFrameVisible() ? n : this.getGaugeBounds().width;
        int n5 = n3 = this.isFrameVisible() ? n2 : this.getGaugeBounds().height;
        if (n4 <= 1 || n3 <= 1) {
            return this;
        }
        if (!this.isFrameVisible()) {
            this.setFramelessOffset((double)(-this.getGaugeBounds().width) * 0.0841121495, (double)(-this.getGaugeBounds().width) * 0.0841121495);
        } else {
            this.setFramelessOffset(this.getGaugeBounds().x, this.getGaugeBounds().y);
        }
        if (this.isDigitalFont()) {
            this.setLcdValueFont(this.getModel().getDigitalBaseFont().deriveFont(0.7f * (float)n4 * 0.1f));
        } else {
            this.setLcdValueFont(this.getModel().getStandardBaseFont().deriveFont(0.625f * (float)n4 * 0.1f));
        }
        if (this.isCustomLcdUnitFontEnabled()) {
            this.setLcdUnitFont(this.getCustomLcdUnitFont().deriveFont(0.25f * (float)n4 * 0.1f));
        } else {
            this.setLcdUnitFont(this.getModel().getStandardBaseFont().deriveFont(0.25f * (float)n4 * 0.1f));
        }
        this.setLcdInfoFont(this.getModel().getStandardInfoFont().deriveFont(0.15f * (float)n4 * 0.1f));
        if (this.bImage != null) {
            this.bImage.flush();
        }
        this.bImage = UTIL.createImage(n4, n4, 3);
        if (this.fImage != null) {
            this.fImage.flush();
        }
        this.fImage = UTIL.createImage(n4, n4, 3);
        if (this.isFrameVisible()) {
            switch (this.getFrameType()) {
                case ROUND: {
                    FRAME_FACTORY.createRadialFrame(n4, this.getFrameDesign(), this.getCustomFrameDesign(), this.getFrameEffect(), this.bImage);
                    break;
                }
                case SQUARE: {
                    FRAME_FACTORY.createLinearFrame(n4, n4, this.getFrameDesign(), this.getCustomFrameDesign(), this.getFrameEffect(), this.bImage);
                    break;
                }
                default: {
                    FRAME_FACTORY.createRadialFrame(n4, this.getFrameDesign(), this.getCustomFrameDesign(), this.getFrameEffect(), this.bImage);
                }
            }
        }
        if (this.isBackgroundVisible()) {
            this.create_BACKGROUND_Image(n4, "", "", this.bImage);
        }
        this.create_TICKMARKS_Image(n4, 0.0, Math.PI, 0.0, 10.0, this.angleStep100ft, (int)this.tickLabelPeriod, 0, true, true, null, this.bImage);
        if (this.isLcdVisible()) {
            this.createLcdImage(new Rectangle2D.Double(((double)this.getGaugeBounds().width - (double)n4 * 0.4) / 2.0, (double)this.getGaugeBounds().height * 0.55, (double)n4 * 0.4, (double)n4 * 0.1), this.getLcdColor(), this.getCustomLcdBackground(), this.bImage);
            this.LCD.setRect(((double)this.getGaugeBounds().width - (double)n4 * 0.4) / 2.0, (double)this.getGaugeBounds().height * 0.55, (double)n4 * 0.4, (double)n4 * 0.1);
        }
        if (this.pointer100FtImage != null) {
            this.pointer100FtImage.flush();
        }
        this.pointer100FtImage = this.create_100FT_POINTER_Image(n4);
        if (this.pointer1000FtImage != null) {
            this.pointer1000FtImage.flush();
        }
        this.pointer1000FtImage = this.create_1000FT_POINTER_Image(n4);
        if (this.pointer10000FtImage != null) {
            this.pointer10000FtImage.flush();
        }
        this.pointer10000FtImage = this.create_10000FT_POINTER_Image(n4);
        this.createPostsImage(n4, this.fImage, PostPosition.CENTER);
        if (this.isForegroundVisible()) {
            switch (this.getFrameType()) {
                case SQUARE: {
                    FOREGROUND_FACTORY.createLinearForeground(n4, n4, false, this.bImage);
                    break;
                }
                default: {
                    FOREGROUND_FACTORY.createRadialForeground(n4, false, this.getForegroundType(), this.fImage);
                }
            }
        }
        if (this.disabledImage != null) {
            this.disabledImage.flush();
        }
        this.disabledImage = this.create_DISABLED_Image(n4);
        return this;
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        if (!this.isInitialized()) {
            return;
        }
        Graphics2D graphics2D = (Graphics2D)graphics.create();
        this.CENTER.setLocation(this.getGaugeBounds().getCenterX(), this.getGaugeBounds().getCenterX());
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        graphics2D.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
        graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        graphics2D.translate(this.getFramelessOffset().getX(), this.getFramelessOffset().getY());
        AffineTransform affineTransform = graphics2D.getTransform();
        graphics2D.drawImage((Image)this.bImage, 0, 0, null);
        if (this.isLcdVisible()) {
            if (this.getLcdColor() == LcdColor.CUSTOM) {
                graphics2D.setColor(this.getCustomLcdForeground());
            } else {
                graphics2D.setColor(this.getLcdColor().TEXT_COLOR);
            }
            graphics2D.setFont(this.getLcdUnitFont());
            if (this.isLcdUnitStringVisible()) {
                this.unitLayout = new TextLayout(this.getLcdUnitString(), graphics2D.getFont(), this.RENDER_CONTEXT);
                this.UNIT_BOUNDARY.setFrame(this.unitLayout.getBounds());
                graphics2D.drawString(this.getLcdUnitString(), (float)(this.LCD.getX() + (this.LCD.getWidth() - this.UNIT_BOUNDARY.getWidth()) - this.LCD.getWidth() * 0.03), (float)(this.LCD.getY() + this.LCD.getHeight() * 0.76));
                this.unitStringWidth = this.UNIT_BOUNDARY.getWidth();
            } else {
                this.unitStringWidth = 0.0;
            }
            graphics2D.setFont(this.getLcdValueFont());
            switch (this.getModel().getNumberSystem()) {
                case HEX: {
                    this.valueLayout = new TextLayout(Integer.toHexString((int)this.getLcdValue()).toUpperCase(), graphics2D.getFont(), this.RENDER_CONTEXT);
                    this.VALUE_BOUNDARY.setFrame(this.valueLayout.getBounds());
                    graphics2D.drawString(Integer.toHexString((int)this.getLcdValue()).toUpperCase(), (float)(this.LCD.getX() + (this.LCD.getWidth() - this.unitStringWidth - this.VALUE_BOUNDARY.getWidth()) - this.LCD.getWidth() * 0.09), (float)(this.LCD.getY() + this.LCD.getHeight() * 0.76));
                    break;
                }
                case OCT: {
                    this.valueLayout = new TextLayout(Integer.toOctalString((int)this.getLcdValue()), graphics2D.getFont(), this.RENDER_CONTEXT);
                    this.VALUE_BOUNDARY.setFrame(this.valueLayout.getBounds());
                    graphics2D.drawString(Integer.toOctalString((int)this.getLcdValue()), (float)(this.LCD.getX() + (this.LCD.getWidth() - this.unitStringWidth - this.VALUE_BOUNDARY.getWidth()) - this.LCD.getWidth() * 0.09), (float)(this.LCD.getY() + this.LCD.getHeight() * 0.76));
                    break;
                }
                default: {
                    this.valueLayout = new TextLayout(this.formatLcdValue(this.getLcdValue()), graphics2D.getFont(), this.RENDER_CONTEXT);
                    this.VALUE_BOUNDARY.setFrame(this.valueLayout.getBounds());
                    graphics2D.drawString(this.formatLcdValue(this.getLcdValue()), (float)(this.LCD.getX() + (this.LCD.getWidth() - this.unitStringWidth - this.VALUE_BOUNDARY.getWidth()) - this.LCD.getWidth() * 0.09), (float)(this.LCD.getY() + this.LCD.getHeight() * 0.76));
                }
            }
            if (!this.getLcdInfoString().isEmpty()) {
                graphics2D.setFont(this.getLcdInfoFont());
                this.infoLayout = new TextLayout(this.getLcdInfoString(), graphics2D.getFont(), this.RENDER_CONTEXT);
                this.INFO_BOUNDARY.setFrame(this.infoLayout.getBounds());
                graphics2D.drawString(this.getLcdInfoString(), (float)this.LCD.getBounds().x + 5.0f, (float)this.LCD.getBounds().y + (float)this.INFO_BOUNDARY.getHeight() + 5.0f);
            }
        }
        graphics2D.rotate((this.value10000 - this.getMinValue()) * this.angleStep10000ft, this.CENTER.getX(), this.CENTER.getY());
        graphics2D.drawImage((Image)this.pointer10000FtImage, 0, 0, null);
        graphics2D.setTransform(affineTransform);
        graphics2D.rotate((this.value1000 - this.getMinValue()) * this.angleStep1000ft, this.CENTER.getX(), this.CENTER.getY());
        graphics2D.drawImage((Image)this.pointer1000FtImage, 0, 0, null);
        graphics2D.setTransform(affineTransform);
        graphics2D.rotate((this.value100 - this.getMinValue()) * this.angleStep100ft, this.CENTER.getX(), this.CENTER.getY());
        graphics2D.drawImage((Image)this.pointer100FtImage, 0, 0, null);
        graphics2D.setTransform(affineTransform);
        graphics2D.drawImage((Image)this.fImage, 0, 0, null);
        if (!this.isEnabled()) {
            graphics2D.drawImage((Image)this.disabledImage, 0, 0, null);
        }
        graphics2D.translate(-this.getInnerBounds().x, -this.getInnerBounds().y);
        graphics2D.dispose();
    }

    @Override
    public void setValue(double d) {
        if (this.isEnabled()) {
            this.value100 = d % 1000.0 / 100.0;
            this.value1000 = d % 10000.0 / 100.0;
            this.value10000 = d % 100000.0 / 100.0;
            if (this.isValueCoupled()) {
                this.setLcdValue(d);
            }
            this.fireStateChanged();
            this.oldValue = d;
            this.repaint();
        }
    }

    @Override
    public void setValueAnimated(double d) {
        if (this.isEnabled()) {
            if (this.timeline.getState() == Timeline.TimelineState.PLAYING_FORWARD || this.timeline.getState() == Timeline.TimelineState.PLAYING_REVERSE) {
                this.timeline.abort();
            }
            this.timeline = new Timeline(this);
            this.timeline.addPropertyToInterpolate("value", this.oldValue, d);
            this.timeline.setEase(new Spline(0.5f));
            double d2 = Math.abs(this.value100 - d);
            double d3 = d2 / 1000.0;
            this.timeline.setDuration((long)(1000.0 * d3));
            this.timeline.play();
        }
    }

    @Override
    public Paint createCustomLcdBackgroundPaint(Color[] colorArray) {
        Point2D.Double double_;
        Point2D.Double double_2 = new Point2D.Double(0.0, this.LCD.getMinY() + 1.0);
        if (double_2.equals(double_ = new Point2D.Double(0.0, this.LCD.getMaxY() - 1.0))) {
            ((Point2D)double_).setLocation(0.0, ((Point2D)double_2).getY() + 1.0);
        }
        float[] fArray = new float[]{0.0f, 0.03f, 0.49f, 0.5f, 1.0f};
        Color[] colorArray2 = new Color[]{colorArray[0], colorArray[1], colorArray[2], colorArray[3], colorArray[4]};
        return new LinearGradientPaint(double_2, double_, fArray, colorArray2);
    }

    @Override
    public Point2D getCenter() {
        return new Point2D.Double((double)this.bImage.getWidth() / 2.0 + (double)this.getInnerBounds().x, (double)this.bImage.getHeight() / 2.0 + (double)this.getInnerBounds().y);
    }

    @Override
    public Rectangle2D getBounds2D() {
        return new Rectangle2D.Double(this.bImage.getMinX(), this.bImage.getMinY(), this.bImage.getWidth(), this.bImage.getHeight());
    }

    @Override
    public Rectangle getLcdBounds() {
        return this.LCD.getBounds();
    }

    private void calcAngleStep() {
        this.angleStep100ft = Math.PI * 2 / (this.getMaxValue() - this.getMinValue());
        this.angleStep1000ft = this.angleStep100ft / 10.0;
        this.angleStep10000ft = this.angleStep1000ft / 10.0;
    }

    private BufferedImage create_TICKMARKS_Image(int n, double d, double d2, double d3, double d4, double d5, int n2, int n3, boolean bl, boolean bl2, ArrayList<Section> arrayList, BufferedImage bufferedImage) {
        double d6;
        if (n <= 0) {
            return null;
        }
        if (bufferedImage == null) {
            bufferedImage = UTIL.createImage(n, n, 3);
        }
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
        graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        int n4 = bufferedImage.getWidth();
        int n5 = bufferedImage.getHeight();
        Font font = new Font("Verdana", 0, (int)(0.09 * (double)n));
        BasicStroke basicStroke = new BasicStroke(2.0f, 1, 2);
        BasicStroke basicStroke2 = new BasicStroke(1.5f, 1, 2);
        int n6 = (int)(0.17 * (double)n);
        int n7 = (int)(0.05 * (double)n);
        int n8 = (int)(0.07 * (double)n);
        Color color = super.getBackgroundColor().LABEL_COLOR;
        Color color2 = super.getBackgroundColor().LABEL_COLOR;
        float f = (float)n4 * 0.4f;
        Point2D.Double double_ = new Point2D.Double((float)n4 / 2.0f, (float)n5 / 2.0f);
        Point2D.Double double_2 = null;
        int n9 = 0;
        int n10 = 0;
        graphics2D.setFont(font);
        double d7 = 0.0;
        double d8 = 0.0;
        double d9 = d6 = -d2 - d / 2.0;
        float f2 = 0.0f;
        while (f2 <= 10.0f) {
            Line2D.Double double_3;
            Point2D.Double double_4;
            Point2D.Double double_5;
            graphics2D.setStroke(basicStroke2);
            d7 = Math.sin(d9);
            d8 = Math.cos(d9);
            if (n9 % 2 == 0) {
                graphics2D.setStroke(basicStroke2);
                double_5 = new Point2D.Double(((Point2D)double_).getX() + (double)(f - (float)n7) * d7, ((Point2D)double_).getY() + (double)(f - (float)n7) * d8);
                double_4 = new Point2D.Double(((Point2D)double_).getX() + (double)f * d7, ((Point2D)double_).getY() + (double)f * d8);
                graphics2D.setColor(color2);
                double_3 = new Line2D.Double(((Point2D)double_5).getX(), ((Point2D)double_5).getY(), ((Point2D)double_4).getX(), ((Point2D)double_4).getY());
                graphics2D.draw(double_3);
            }
            if (n9 == 10 || n9 == 0) {
                graphics2D.setColor(color);
                graphics2D.setStroke(basicStroke);
                double_5 = new Point2D.Double(((Point2D)double_).getX() + (double)(f - (float)n8) * d7, ((Point2D)double_).getY() + (double)(f - (float)n8) * d8);
                double_4 = new Point2D.Double(((Point2D)double_).getX() + (double)f * d7, ((Point2D)double_).getY() + (double)f * d8);
                double_2 = new Point2D.Double(((Point2D)double_).getX() + (double)(f - (float)n6 + (float)font.getSize() / 2.0f) * d7, ((Point2D)double_).getY() + (double)(f - (float)n6 + (float)font.getSize() / 2.0f) * d8 + (double)((float)n6 / 2.5f));
                TextLayout textLayout = new TextLayout(String.valueOf(Math.round(f2)), graphics2D.getFont(), this.RENDER_CONTEXT);
                Rectangle2D rectangle2D = textLayout.getBounds();
                if (d == 0.0) {
                    if (Float.compare(f2, 10.0f) != 0) {
                        graphics2D.drawString(String.valueOf(Math.round(f2)), (int)(((Point2D)double_2).getX() - rectangle2D.getWidth() / 2.0), (int)(((Point2D)double_2).getY() - rectangle2D.getHeight() / 2.0));
                    }
                } else {
                    graphics2D.drawString(String.valueOf(Math.round(f2)), (int)(((Point2D)double_2).getX() - rectangle2D.getWidth() / 2.0), (int)(((Point2D)double_2).getY() - rectangle2D.getHeight() / 2.0));
                }
                n9 = 0;
                ++n10;
                graphics2D.setColor(color2);
                double_3 = new Line2D.Double(((Point2D)double_5).getX(), ((Point2D)double_5).getY(), ((Point2D)double_4).getX(), ((Point2D)double_4).getY());
                graphics2D.draw(double_3);
            }
            ++n9;
            d9 -= d5 * 0.1;
            f2 = (float)((double)f2 + 0.1);
        }
        graphics2D.dispose();
        return bufferedImage;
    }

    private BufferedImage create_100FT_POINTER_Image(int n) {
        if (n <= 0) {
            return null;
        }
        BufferedImage bufferedImage = UTIL.createImage(n, (int)(1.0 * (double)n), 3);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        graphics2D.setRenderingHint(RenderingHints.KEY_DITHERING, RenderingHints.VALUE_DITHER_ENABLE);
        graphics2D.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
        int n2 = bufferedImage.getWidth();
        int n3 = bufferedImage.getHeight();
        GeneralPath generalPath = new GeneralPath();
        generalPath.setWindingRule(0);
        generalPath.moveTo((double)n2 * 0.5186915887850467, (double)n3 * 0.4719626168224299);
        generalPath.curveTo((double)n2 * 0.514018691588785, (double)n3 * 0.4719626168224299, (double)n2 * 0.5093457943925234, (double)n3 * 0.4672897196261682, (double)n2 * 0.5093457943925234, (double)n3 * 0.4672897196261682);
        generalPath.lineTo((double)n2 * 0.5093457943925234, (double)n3 * 0.20093457943925233);
        generalPath.lineTo((double)n2 * 0.5, (double)n3 * 0.16822429906542055);
        generalPath.lineTo((double)n2 * 0.49065420560747663, (double)n3 * 0.20093457943925233);
        generalPath.lineTo((double)n2 * 0.49065420560747663, (double)n3 * 0.4672897196261682);
        generalPath.curveTo((double)n2 * 0.49065420560747663, (double)n3 * 0.4672897196261682, (double)n2 * 0.48130841121495327, (double)n3 * 0.4719626168224299, (double)n2 * 0.48130841121495327, (double)n3 * 0.4719626168224299);
        generalPath.curveTo((double)n2 * 0.4719626168224299, (double)n3 * 0.48130841121495327, (double)n2 * 0.4672897196261682, (double)n3 * 0.49065420560747663, (double)n2 * 0.4672897196261682, (double)n3 * 0.5);
        generalPath.curveTo((double)n2 * 0.4672897196261682, (double)n3 * 0.514018691588785, (double)n2 * 0.4766355140186916, (double)n3 * 0.5280373831775701, (double)n2 * 0.49065420560747663, (double)n3 * 0.5327102803738317);
        generalPath.curveTo((double)n2 * 0.49065420560747663, (double)n3 * 0.5327102803738317, (double)n2 * 0.49065420560747663, (double)n3 * 0.5794392523364486, (double)n2 * 0.49065420560747663, (double)n3 * 0.5887850467289719);
        generalPath.curveTo((double)n2 * 0.48598130841121495, (double)n3 * 0.5934579439252337, (double)n2 * 0.48130841121495327, (double)n3 * 0.5981308411214953, (double)n2 * 0.48130841121495327, (double)n3 * 0.6074766355140186);
        generalPath.curveTo((double)n2 * 0.48130841121495327, (double)n3 * 0.616822429906542, (double)n2 * 0.49065420560747663, (double)n3 * 0.6261682242990654, (double)n2 * 0.5, (double)n3 * 0.6261682242990654);
        generalPath.curveTo((double)n2 * 0.5093457943925234, (double)n3 * 0.6261682242990654, (double)n2 * 0.5186915887850467, (double)n3 * 0.616822429906542, (double)n2 * 0.5186915887850467, (double)n3 * 0.6074766355140186);
        generalPath.curveTo((double)n2 * 0.5186915887850467, (double)n3 * 0.5981308411214953, (double)n2 * 0.514018691588785, (double)n3 * 0.5934579439252337, (double)n2 * 0.5046728971962616, (double)n3 * 0.5887850467289719);
        generalPath.curveTo((double)n2 * 0.5046728971962616, (double)n3 * 0.5794392523364486, (double)n2 * 0.5046728971962616, (double)n3 * 0.5327102803738317, (double)n2 * 0.5093457943925234, (double)n3 * 0.5327102803738317);
        generalPath.curveTo((double)n2 * 0.5233644859813084, (double)n3 * 0.5280373831775701, (double)n2 * 0.5327102803738317, (double)n3 * 0.514018691588785, (double)n2 * 0.5327102803738317, (double)n3 * 0.5);
        generalPath.curveTo((double)n2 * 0.5327102803738317, (double)n3 * 0.49065420560747663, (double)n2 * 0.5280373831775701, (double)n3 * 0.48130841121495327, (double)n2 * 0.5186915887850467, (double)n3 * 0.4719626168224299);
        generalPath.closePath();
        Point2D.Double double_ = new Point2D.Double(0.0, generalPath.getBounds2D().getMinY());
        Point2D.Double double_2 = new Point2D.Double(0.0, generalPath.getBounds2D().getMaxY());
        float[] fArray = new float[]{0.0f, 0.31f, 0.3101f, 0.32f, 1.0f};
        Color[] colorArray = new Color[]{new Color(255, 255, 255, 255), new Color(255, 255, 255, 255), new Color(255, 255, 255, 255), new Color(32, 32, 32, 255), new Color(32, 32, 32, 255)};
        LinearGradientPaint linearGradientPaint = new LinearGradientPaint(double_, double_2, fArray, colorArray);
        graphics2D.setPaint(linearGradientPaint);
        graphics2D.fill(generalPath);
        graphics2D.dispose();
        return bufferedImage;
    }

    private BufferedImage create_1000FT_POINTER_Image(int n) {
        if (n <= 0) {
            return null;
        }
        BufferedImage bufferedImage = UTIL.createImage(n, (int)(1.0 * (double)n), 3);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        graphics2D.setRenderingHint(RenderingHints.KEY_DITHERING, RenderingHints.VALUE_DITHER_ENABLE);
        graphics2D.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
        int n2 = bufferedImage.getWidth();
        int n3 = bufferedImage.getHeight();
        GeneralPath generalPath = new GeneralPath();
        generalPath.setWindingRule(0);
        generalPath.moveTo((double)n2 * 0.5186915887850467, (double)n3 * 0.4719626168224299);
        generalPath.curveTo((double)n2 * 0.514018691588785, (double)n3 * 0.46261682242990654, (double)n2 * 0.5280373831775701, (double)n3 * 0.40186915887850466, (double)n2 * 0.5280373831775701, (double)n3 * 0.40186915887850466);
        generalPath.lineTo((double)n2 * 0.5, (double)n3 * 0.3317757009345794);
        generalPath.lineTo((double)n2 * 0.4719626168224299, (double)n3 * 0.40186915887850466);
        generalPath.curveTo((double)n2 * 0.4719626168224299, (double)n3 * 0.40186915887850466, (double)n2 * 0.48598130841121495, (double)n3 * 0.46261682242990654, (double)n2 * 0.48130841121495327, (double)n3 * 0.4719626168224299);
        generalPath.curveTo((double)n2 * 0.4719626168224299, (double)n3 * 0.48130841121495327, (double)n2 * 0.4672897196261682, (double)n3 * 0.49065420560747663, (double)n2 * 0.4672897196261682, (double)n3 * 0.5);
        generalPath.curveTo((double)n2 * 0.4672897196261682, (double)n3 * 0.514018691588785, (double)n2 * 0.4766355140186916, (double)n3 * 0.5280373831775701, (double)n2 * 0.49065420560747663, (double)n3 * 0.5327102803738317);
        generalPath.curveTo((double)n2 * 0.49065420560747663, (double)n3 * 0.5327102803738317, (double)n2 * 0.46261682242990654, (double)n3 * 0.5747663551401869, (double)n2 * 0.46261682242990654, (double)n3 * 0.5934579439252337);
        generalPath.curveTo((double)n2 * 0.4672897196261682, (double)n3 * 0.616822429906542, (double)n2 * 0.5, (double)n3 * 0.6121495327102804, (double)n2 * 0.5, (double)n3 * 0.6121495327102804);
        generalPath.curveTo((double)n2 * 0.5, (double)n3 * 0.6121495327102804, (double)n2 * 0.5327102803738317, (double)n3 * 0.616822429906542, (double)n2 * 0.5373831775700935, (double)n3 * 0.5934579439252337);
        generalPath.curveTo((double)n2 * 0.5373831775700935, (double)n3 * 0.5747663551401869, (double)n2 * 0.5093457943925234, (double)n3 * 0.5327102803738317, (double)n2 * 0.5093457943925234, (double)n3 * 0.5327102803738317);
        generalPath.curveTo((double)n2 * 0.5233644859813084, (double)n3 * 0.5280373831775701, (double)n2 * 0.5327102803738317, (double)n3 * 0.514018691588785, (double)n2 * 0.5327102803738317, (double)n3 * 0.5);
        generalPath.curveTo((double)n2 * 0.5327102803738317, (double)n3 * 0.49065420560747663, (double)n2 * 0.5280373831775701, (double)n3 * 0.48130841121495327, (double)n2 * 0.5186915887850467, (double)n3 * 0.4719626168224299);
        generalPath.closePath();
        Point2D.Double double_ = new Point2D.Double(0.0, generalPath.getBounds2D().getMinY());
        Point2D.Double double_2 = new Point2D.Double(0.0, generalPath.getBounds2D().getMaxY());
        float[] fArray = new float[]{0.0f, 0.51f, 0.52f, 0.5201f, 0.53f, 1.0f};
        Color[] colorArray = new Color[]{new Color(255, 255, 255, 255), new Color(255, 255, 255, 255), new Color(255, 255, 255, 255), new Color(32, 32, 32, 255), new Color(32, 32, 32, 255), new Color(32, 32, 32, 255)};
        LinearGradientPaint linearGradientPaint = new LinearGradientPaint(double_, double_2, fArray, colorArray);
        graphics2D.setPaint(linearGradientPaint);
        graphics2D.fill(generalPath);
        graphics2D.dispose();
        return bufferedImage;
    }

    private BufferedImage create_10000FT_POINTER_Image(int n) {
        if (n <= 0) {
            return null;
        }
        BufferedImage bufferedImage = UTIL.createImage(n, (int)(1.0 * (double)n), 3);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        graphics2D.setRenderingHint(RenderingHints.KEY_DITHERING, RenderingHints.VALUE_DITHER_ENABLE);
        graphics2D.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
        int n2 = bufferedImage.getWidth();
        int n3 = bufferedImage.getHeight();
        GeneralPath generalPath = new GeneralPath();
        generalPath.setWindingRule(0);
        generalPath.moveTo((double)n2 * 0.5186915887850467, (double)n3 * 0.4719626168224299);
        generalPath.curveTo((double)n2 * 0.514018691588785, (double)n3 * 0.4719626168224299, (double)n2 * 0.514018691588785, (double)n3 * 0.4672897196261682, (double)n2 * 0.514018691588785, (double)n3 * 0.4672897196261682);
        generalPath.lineTo((double)n2 * 0.514018691588785, (double)n3 * 0.3177570093457944);
        generalPath.lineTo((double)n2 * 0.5046728971962616, (double)n3 * 0.3037383177570093);
        generalPath.lineTo((double)n2 * 0.5046728971962616, (double)n3 * 0.1822429906542056);
        generalPath.lineTo((double)n2 * 0.5327102803738317, (double)n3 * 0.11682242990654206);
        generalPath.lineTo((double)n2 * 0.46261682242990654, (double)n3 * 0.11682242990654206);
        generalPath.lineTo((double)n2 * 0.4953271028037383, (double)n3 * 0.1822429906542056);
        generalPath.lineTo((double)n2 * 0.4953271028037383, (double)n3 * 0.29906542056074764);
        generalPath.lineTo((double)n2 * 0.48598130841121495, (double)n3 * 0.3177570093457944);
        generalPath.lineTo((double)n2 * 0.48598130841121495, (double)n3 * 0.4672897196261682);
        generalPath.curveTo((double)n2 * 0.48598130841121495, (double)n3 * 0.4672897196261682, (double)n2 * 0.48598130841121495, (double)n3 * 0.4719626168224299, (double)n2 * 0.48130841121495327, (double)n3 * 0.4719626168224299);
        generalPath.curveTo((double)n2 * 0.4719626168224299, (double)n3 * 0.48130841121495327, (double)n2 * 0.4672897196261682, (double)n3 * 0.49065420560747663, (double)n2 * 0.4672897196261682, (double)n3 * 0.5);
        generalPath.curveTo((double)n2 * 0.4672897196261682, (double)n3 * 0.5186915887850467, (double)n2 * 0.48130841121495327, (double)n3 * 0.5327102803738317, (double)n2 * 0.5, (double)n3 * 0.5327102803738317);
        generalPath.curveTo((double)n2 * 0.5186915887850467, (double)n3 * 0.5327102803738317, (double)n2 * 0.5327102803738317, (double)n3 * 0.5186915887850467, (double)n2 * 0.5327102803738317, (double)n3 * 0.5);
        generalPath.curveTo((double)n2 * 0.5327102803738317, (double)n3 * 0.49065420560747663, (double)n2 * 0.5280373831775701, (double)n3 * 0.48130841121495327, (double)n2 * 0.5186915887850467, (double)n3 * 0.4719626168224299);
        generalPath.closePath();
        graphics2D.setColor(Color.WHITE);
        graphics2D.fill(generalPath);
        graphics2D.dispose();
        return bufferedImage;
    }

    @Override
    public String toString() {
        return "Altimeter";
    }
}

