/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi.output;

import com.rusefi.ConfigField;
import com.rusefi.ReaderState;
import com.rusefi.output.ConfigStructure;
import com.rusefi.output.DataLogConsumer;
import com.rusefi.output.JavaSensorsConsumer;
import com.rusefi.output.PerFieldWithStructuresIterator;
import java.io.IOException;

public class SdCardFieldsContent {
    private final StringBuilder body = new StringBuilder();
    public String home = "engine->outputChannels";

    public void handleEndStruct(ReaderState state, ConfigStructure structure) throws IOException {
        if (state.isStackEmpty()) {
            PerFieldWithStructuresIterator iterator = new PerFieldWithStructuresIterator(state, structure.getTsFields(), "", (configField, prefix, prefix2) -> this.processOutput(prefix, prefix2), ".");
            iterator.loop();
            String content = iterator.getContent();
            this.body.append(content);
        }
    }

    private String processOutput(ConfigField configField, String prefix) {
        if (configField.getName().startsWith("alignmentFill_at_")) {
            return "";
        }
        if (configField.getName().startsWith("unused")) {
            return "";
        }
        if (configField.isBit()) {
            return "";
        }
        if (configField.isFromIterate()) {
            String name = configField.getIterateOriginalName() + "[" + (configField.getIterateIndex() - 1) + "]";
            return this.getLine(configField, prefix, prefix + name);
        }
        return this.getLine(configField, prefix, prefix + configField.getName());
    }

    private String getLine(ConfigField configField, String prefix, String name) {
        return "\t{" + this.home + "." + name + ", " + DataLogConsumer.getHumanGaugeName(prefix, configField) + ", " + JavaSensorsConsumer.quote(configField.getUnits()) + ", " + configField.getDigits() + ", " + configField.getCategory() + "},\n";
    }

    public String getBody() {
        return this.body.toString();
    }
}

