/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi.output;

import com.rusefi.ReaderStateImpl;
import com.rusefi.output.JavaFieldsConsumer;
import com.rusefi.util.LazyFile;
import java.io.File;
import java.io.IOException;

public class FileJavaFieldsConsumer
extends JavaFieldsConsumer {
    private static final String JAVA_PACKAGE = "com.rusefi.config.generated";
    private final LazyFile javaFields;
    private final String className;

    public FileJavaFieldsConsumer(ReaderStateImpl state, String javaDestination, int baseOffset) {
        super(state, baseOffset);
        this.javaFields = new LazyFile(javaDestination);
        String className = new File(javaDestination).getName();
        this.className = className.substring(0, className.indexOf(46));
    }

    @Override
    public void startFile() {
        this.javaFields.write("package com.rusefi.config.generated;\n\n");
        this.javaFields.write("// this file " + this.state.getHeader() + "\n" + "\n");
        this.javaFields.write("// by " + this.getClass() + "\n");
        this.javaFields.write("import com.rusefi.config.*;\n\n");
        this.javaFields.write("public class " + this.className + " {" + "\n");
    }

    @Override
    public void endFile() throws IOException {
        this.javaFields.write(this.state.getVariableRegistry().getJavaConstants());
        this.javaFields.write(this.getContent());
        this.allFields.append("\t};\n");
        this.javaFields.write(this.allFields.toString());
        this.javaFields.write("}\n");
        this.javaFields.close();
    }
}

