/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi.logic;

public class IgnitionMapBuilder {
    public static double getTopAdvanceForBore(ChamberStyle style, int octane, double compression, double bore) {
        int octaneCorrection = octane <= 90 ? -2 : (octane < 94 ? -1 : 0);
        int compressionCorrection = compression <= 9.0 ? 2 : (compression <= 10.0 ? 1 : (compression <= 11.0 ? 0 : -2));
        double result = (double)(style.advance + octaneCorrection + compressionCorrection) + IgnitionMapBuilder.getBoreCorrection(bore);
        return IgnitionMapBuilder.round10(result);
    }

    public static double interpolate(double x1, double y1, double x2, double y2, double x) {
        double a = (y1 - y2) / (x1 - x2);
        double b = y1 - a * x1;
        return a * x + b;
    }

    public static double getAdvanceForRpm(int rpm, double advanceMax) {
        if (rpm >= 3000) {
            return advanceMax;
        }
        if (rpm < 600) {
            return 10.0;
        }
        return IgnitionMapBuilder.interpolate(600.0, 10.0, 3000.0, advanceMax, rpm);
    }

    public static double getInitialAdvance(int rpm, double map, double advanceMax) {
        double advance = IgnitionMapBuilder.getAdvanceForRpm(rpm, advanceMax);
        if (rpm > 3000) {
            return IgnitionMapBuilder.round10(advance + 0.1 * (100.0 - map));
        }
        return IgnitionMapBuilder.round10(advance + 0.1 * (100.0 - map) * (double)rpm / 3000.0);
    }

    public static double round10(double result) {
        return (double)((int)(result * 10.0)) / 10.0;
    }

    public static double getBoreCorrection(double bore) {
        return (bore - 101.6) / 25.4 * 6.0;
    }

    public static enum ChamberStyle {
        OPEN_CHAMBER(33),
        CLOSED_CHAMBER(28),
        SWIRL_TUMBLE(22);

        private final int advance;

        private ChamberStyle(int advance) {
            this.advance = advance;
        }
    }
}

