/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi;

import com.rusefi.FileLog;
import com.rusefi.binaryprotocol.BinaryProtocol;
import com.rusefi.binaryprotocol.IoHelper;
import com.rusefi.tools.ConsoleTools;
import com.rusefi.tracing.Entry;
import com.rusefi.tracing.JsonOutput;
import com.rusefi.ui.RpmModel;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JOptionPane;

public class PerformanceTraceHelper {
    public static void grabPerformanceTrace(JComponent parent, BinaryProtocol bp) {
        if (bp == null) {
            JOptionPane.showMessageDialog(parent, "Failed to locate serial ports");
            return;
        }
        bp.executeCommand('_', "begin trace");
        try {
            Thread.sleep(500L);
            byte[] packet = bp.executeCommand('b', "get trace");
            if (!IoHelper.checkResponseCode(packet, (byte)0) || (packet.length - 1) % 8 != 0) {
                throw new IllegalStateException("Unexpected packet, length=" + (packet != null ? 0 : packet.length));
            }
            List<Entry> data = Entry.parseBuffer(packet);
            int rpm = RpmModel.getInstance().getValue();
            String fileName = FileLog.getDate() + "_rpm_" + rpm + "_rusEFI_trace.json";
            JsonOutput.writeToStream(data, new FileOutputStream(fileName));
        }
        catch (IOException | InterruptedException e1) {
            throw new IllegalStateException(e1);
        }
    }

    public static void getPerformanceTune() {
        ConsoleTools.startAndConnect(linkManager -> {
            BinaryProtocol binaryProtocol = linkManager.getConnector().getBinaryProtocol();
            PerformanceTraceHelper.grabPerformanceTrace(null, binaryProtocol);
            System.exit(0);
            return null;
        });
    }
}

