/*
 * Decompiled with CFR 0.152.
 */
package com.opensr5.io;

import com.opensr5.ConfigurationImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Arrays;
import org.jetbrains.annotations.Nullable;

public class ConfigurationImageFile {
    private ConfigurationImageFile() {
    }

    public static ConfigurationImage readFromFile(String fileName) throws IOException {
        File file = new File(fileName);
        int size = (int)file.length();
        FileInputStream fis = new FileInputStream(fileName);
        return ConfigurationImageFile.readFromStream(size, fis);
    }

    @Nullable
    private static ConfigurationImage readFromStream(int size, FileInputStream fis) throws IOException {
        int contentSize = size - "OPEN_SR5_0.1".length();
        byte[] header = new byte["OPEN_SR5_0.1".length()];
        int result = fis.read(header);
        if (result != header.length) {
            System.err.println("Error reading header bytes, got " + result);
            return null;
        }
        if (!Arrays.equals(header, "OPEN_SR5_0.1".getBytes())) {
            System.err.println("Header mismatch");
            return null;
        }
        ConfigurationImage image = new ConfigurationImage(contentSize);
        result = fis.read(image.getContent());
        return result == image.getContent().length ? image : null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static byte[] getFileContent(ConfigurationImage configurationImage) {
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
            byte[] bytes = "OPEN_SR5_0.1".getBytes();
            if (bytes.length != "OPEN_SR5_0.1".length()) {
                throw new IllegalStateException("Encoding issue");
            }
            baos.write(bytes);
            baos.write(configurationImage.getContent());
            byte[] byArray = baos.toByteArray();
            return byArray;
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    public static void saveToFile(ConfigurationImage configurationImage, String fileName) throws IOException {
        System.out.printf("Saving " + configurationImage.getSize() + " bytes of configuration into " + fileName, new Object[0]);
        FileOutputStream fos = new FileOutputStream(fileName);
        fos.write(ConfigurationImageFile.getFileContent(configurationImage));
        fos.close();
        System.out.println("Saved to " + fileName);
    }
}

