/*
 * Decompiled with CFR 0.152.
 */
package tel.schich.javacan;

import java.util.EnumSet;
import java.util.Objects;
import java.util.Set;

public class IsotpOptions {
    public static final byte DEFAULT_PADDING_CONTENT = -52;
    public static final byte DEFAULT_EXTENDED_ADDRESS = 0;
    public static final IsotpOptions DEFAULT = new IsotpOptions(0, 0, 0, -52, -52, 0);
    private final int rawFlags;
    private final Set<Flag> flags;
    private final int frameTransmissionTime;
    private final byte extendedTransmissionAddress;
    private final byte transmissionPadding;
    private final byte receivePadding;
    private final byte extendedReceiveAddress;

    public IsotpOptions(int rawFlags, int frameTransmissionTime, byte extendedTransmissionAddress, byte transmissionPadding, byte receivePadding, byte extendedReceiveAddress) {
        this(rawFlags, Flag.fromBits(rawFlags), frameTransmissionTime, extendedTransmissionAddress, transmissionPadding, receivePadding, extendedReceiveAddress);
    }

    public IsotpOptions(Set<Flag> flags, int frameTransmissionTime, byte extendedTransmissionAddress, byte transmissionPadding, byte receivePadding, byte extendedReceiveAddress) {
        this(Flag.toBits(flags), flags, frameTransmissionTime, extendedTransmissionAddress, transmissionPadding, receivePadding, extendedReceiveAddress);
    }

    private IsotpOptions(int rawFlags, Set<Flag> flags, int frameTransmissionTime, byte extendedTransmissionAddress, byte transmissionPadding, byte receivePadding, byte extendedReceiveAddress) {
        this.rawFlags = rawFlags;
        this.flags = flags;
        this.frameTransmissionTime = frameTransmissionTime;
        this.extendedTransmissionAddress = extendedTransmissionAddress;
        this.transmissionPadding = transmissionPadding;
        this.receivePadding = receivePadding;
        this.extendedReceiveAddress = extendedReceiveAddress;
    }

    public int getRawFlags() {
        return this.rawFlags;
    }

    public Set<Flag> getFlags() {
        return this.flags;
    }

    public IsotpOptions withRawFlags(int rawFlags) {
        return new IsotpOptions(rawFlags, this.frameTransmissionTime, this.extendedTransmissionAddress, this.transmissionPadding, this.receivePadding, this.extendedReceiveAddress);
    }

    public IsotpOptions withFlags(Set<Flag> flags) {
        return new IsotpOptions(flags, this.frameTransmissionTime, this.extendedTransmissionAddress, this.transmissionPadding, this.receivePadding, this.extendedReceiveAddress);
    }

    public IsotpOptions withFlag(Flag flag) {
        EnumSet<Flag> flags = EnumSet.copyOf(this.flags);
        flags.add(flag);
        return this.withFlags(flags);
    }

    public int getFrameTransmissionTime() {
        return this.frameTransmissionTime;
    }

    public IsotpOptions withFrameTransmissionType(int frameTransmissionTime) {
        return new IsotpOptions(this.rawFlags, this.flags, frameTransmissionTime, this.extendedTransmissionAddress, this.transmissionPadding, this.receivePadding, this.extendedReceiveAddress);
    }

    public byte getExtendedTransmissionAddress() {
        return this.extendedTransmissionAddress;
    }

    public IsotpOptions ExtendedTransmissionAddress(byte extendedTransmissionAddress) {
        return new IsotpOptions(this.rawFlags, this.flags, this.frameTransmissionTime, extendedTransmissionAddress, this.transmissionPadding, this.receivePadding, this.extendedReceiveAddress);
    }

    public byte getTransmissionPadding() {
        return this.transmissionPadding;
    }

    public IsotpOptions withTransmissionPadding(byte transmissionPadding) {
        return new IsotpOptions(this.rawFlags, this.flags, this.frameTransmissionTime, this.extendedTransmissionAddress, transmissionPadding, this.receivePadding, this.extendedReceiveAddress);
    }

    public byte getReceivePadding() {
        return this.receivePadding;
    }

    public IsotpOptions withReceivePadding(byte receivePadding) {
        return new IsotpOptions(this.rawFlags, this.flags, this.frameTransmissionTime, this.extendedTransmissionAddress, this.transmissionPadding, receivePadding, this.extendedReceiveAddress);
    }

    public IsotpOptions withPadding(byte transmissionPadding, byte receivePadding) {
        return new IsotpOptions(this.rawFlags, this.flags, this.frameTransmissionTime, this.extendedTransmissionAddress, transmissionPadding, receivePadding, this.extendedReceiveAddress);
    }

    public IsotpOptions withPadding(byte padding) {
        return this.withPadding(padding, padding);
    }

    public IsotpOptions withPadding(int padding) {
        return this.withPadding((byte)padding);
    }

    public byte getExtendedReceiveAddress() {
        return this.extendedReceiveAddress;
    }

    public IsotpOptions withExtendedReceiveAddress(byte extendedReceiveAddress) {
        return new IsotpOptions(this.rawFlags, this.flags, this.frameTransmissionTime, this.extendedTransmissionAddress, this.transmissionPadding, this.receivePadding, extendedReceiveAddress);
    }

    public IsotpOptions withExtendedAddresses(byte extendedTransmissionAddress, byte extendedReceiveAddress) {
        return new IsotpOptions(this.rawFlags, this.flags, this.frameTransmissionTime, extendedTransmissionAddress, this.transmissionPadding, this.receivePadding, extendedReceiveAddress);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IsotpOptions that = (IsotpOptions)o;
        return this.rawFlags == that.rawFlags && this.frameTransmissionTime == that.frameTransmissionTime && this.extendedTransmissionAddress == that.extendedTransmissionAddress && this.transmissionPadding == that.transmissionPadding && this.receivePadding == that.receivePadding && this.extendedReceiveAddress == that.extendedReceiveAddress;
    }

    public int hashCode() {
        return Objects.hash(this.rawFlags, this.frameTransmissionTime, this.extendedTransmissionAddress, this.transmissionPadding, this.receivePadding, this.extendedReceiveAddress);
    }

    public String toString() {
        return "IsotpOptions(flags=" + this.flags + ", frameTransmissionTime=" + this.frameTransmissionTime + ", extendedTransmissionAddress=" + this.extendedTransmissionAddress + ", transmissionPadding=" + this.transmissionPadding + ", receivePadding=" + this.receivePadding + ", extendedReceiveAddress=" + this.extendedReceiveAddress + ')';
    }

    public static enum Flag {
        LISTEN_MODE(1, "listen only (do not send FC)"),
        EXTEND_ADDR(2, "enable extended addressing"),
        TX_PADDING(4, "enable CAN frame padding tx path"),
        RX_PADDING(8, "enable CAN frame padding rx path"),
        CHK_PAD_LEN(16, "check received CAN frame padding"),
        CHK_PAD_DATA(32, "check received CAN frame padding"),
        HALF_DUPLEX(64, "half duplex error state handling"),
        FORCE_TXSTMIN(128, "ignore stmin from received FC"),
        FORCE_RXSTMIN(256, "ignore CFs depending on rx stmin"),
        RX_EXT_ADDR(512, "different rx extended addressing"),
        WAIT_TX_DONE(1024, "wait for tx completion");

        private final int bit;
        private final String description;

        private Flag(int bit, String description) {
            this.bit = bit;
            this.description = description;
        }

        public int getBit() {
            return this.bit;
        }

        public String getDescription() {
            return this.description;
        }

        public static Set<Flag> fromBits(int bits) {
            EnumSet<Flag> flags = EnumSet.noneOf(Flag.class);
            for (Flag flag : Flag.values()) {
                if ((bits & flag.bit) != flag.bit) continue;
                flags.add(flag);
            }
            return flags;
        }

        public static int toBits(Set<Flag> flags) {
            int rawFlags = 0;
            for (Flag flag : flags) {
                rawFlags |= flag.getBit();
            }
            return rawFlags;
        }

        public String toString() {
            return "Flag(bit=" + Integer.toHexString(this.bit) + ", description='" + this.description + "')";
        }
    }
}

