/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi.binaryprotocol.test;

import com.devexperts.logging.Logging;
import com.opensr5.ConfigurationImage;
import com.rusefi.binaryprotocol.BinaryProtocol;
import com.rusefi.binaryprotocol.test.PCanSandbox;
import com.rusefi.binaryprotocol.test.SandboxCommon;
import com.rusefi.io.LinkManager;
import com.rusefi.io.stream.SocketCANIoStream;
import java.io.IOException;

public class SocketCANSandbox {
    private static final Logging log = Logging.getLogging(PCanSandbox.class);

    public static void main(String[] args) throws IOException, InterruptedException {
        SocketCANIoStream tsStream = SocketCANIoStream.create();
        if (tsStream == null) {
            throw new IOException("No SocketCAN");
        }
        LinkManager linkManager = new LinkManager();
        BinaryProtocol bp = new BinaryProtocol(linkManager, tsStream);
        linkManager.submit(() -> {
            boolean response = bp.requestOutputChannels();
            log.info("requestOutputChannels " + response);
        });
        ConfigurationImage ci = SandboxCommon.readImage(tsStream, linkManager);
        log.info("Got ConfigurationImage " + ci);
    }
}

