/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi.newparse;

import com.rusefi.EnumsReader;
import com.rusefi.VariableRegistry;
import com.rusefi.enum_reader.Value;
import com.rusefi.generated.RusefiConfigGrammarBaseListener;
import com.rusefi.generated.RusefiConfigGrammarParser;
import com.rusefi.newparse.DefinitionsState;
import com.rusefi.newparse.parsing.ArrayField;
import com.rusefi.newparse.parsing.BitField;
import com.rusefi.newparse.parsing.BitGroup;
import com.rusefi.newparse.parsing.Definition;
import com.rusefi.newparse.parsing.EnumField;
import com.rusefi.newparse.parsing.EnumTypedef;
import com.rusefi.newparse.parsing.Field;
import com.rusefi.newparse.parsing.FieldOptions;
import com.rusefi.newparse.parsing.ScalarField;
import com.rusefi.newparse.parsing.ScalarTypedef;
import com.rusefi.newparse.parsing.StringField;
import com.rusefi.newparse.parsing.StringTypedef;
import com.rusefi.newparse.parsing.Struct;
import com.rusefi.newparse.parsing.StructField;
import com.rusefi.newparse.parsing.Type;
import com.rusefi.newparse.parsing.Typedef;
import com.rusefi.newparse.parsing.Union;
import com.rusefi.newparse.parsing.UnusedField;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Stack;
import java.util.TreeMap;
import java.util.regex.Pattern;
import org.antlr.v4.runtime.tree.ParseTreeListener;

public class ParseState
implements DefinitionsState {
    private final Map<String, Definition> definitions = new HashMap<String, Definition>();
    private final Map<String, Struct> structs = new HashMap<String, Struct>();
    private final List<Struct> structList = new ArrayList<Struct>();
    private final Map<String, Typedef> typedefs = new HashMap<String, Typedef>();
    private static final Pattern CHAR_LITERAL = Pattern.compile("'.'");
    private final EnumsReader enumsReader;
    private Definition.OverwritePolicy definitionOverwritePolicy = Definition.OverwritePolicy.NotAllowed;
    private String typedefName = null;
    private final Queue<Double> evalResults = new LinkedList<Double>();
    private Scope scope = null;
    private final Stack<Scope> scopes = new Stack();
    private Struct lastStruct = null;

    public ParseState() {
        this.enumsReader = null;
    }

    public ParseState(EnumsReader enumsReader) {
        this.enumsReader = enumsReader;
        for (Map.Entry<String, EnumsReader.EnumState> enumType : this.enumsReader.getEnums().entrySet()) {
            String name = enumType.getKey();
            for (Value enumValue : enumType.getValue().values()) {
                try {
                    int value = enumValue.getIntValue();
                    this.handleIntDefinition(name + "_" + enumValue.getName(), value);
                }
                catch (Exception exception) {}
            }
        }
    }

    private void handleIntDefinition(String name, int value) {
        this.addDefinition(name, value);
        this.addDefinition(name + "_16_hex", String.format("\\x%02x\\x%02x", value >> 8 & 0xFF, value & 0xFF));
    }

    private static boolean isNumeric(String str) {
        try {
            Integer.parseInt(str);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    public Struct getLastStruct() {
        return this.lastStruct;
    }

    private String[] resolveEnumValues(String enumName) {
        if (this.enumsReader == null) {
            return new String[0];
        }
        TreeMap<Integer, String> valueNameById = new TreeMap<Integer, String>();
        EnumsReader.EnumState stringValueMap = this.enumsReader.getEnums().get(enumName);
        if (stringValueMap == null) {
            return null;
        }
        for (Value value : stringValueMap.values()) {
            if (value.isForceSize()) continue;
            if (ParseState.isNumeric(value.getValue())) {
                valueNameById.put(value.getIntValue(), value.getName());
                continue;
            }
            Definition def = this.definitions.get(value.getValue());
            if (def == null) {
                throw new IllegalStateException("No value for " + value);
            }
            valueNameById.put((Integer)def.value, value.getName());
        }
        String[] result = new String[(Integer)valueNameById.lastKey() + 1];
        for (int i = 0; i < result.length; ++i) {
            result[i] = valueNameById.getOrDefault(i, "INVALID");
        }
        return result;
    }

    public List<Struct> getStructs() {
        return this.structList;
    }

    public Definition findDefinition(String name) {
        return this.definitions.getOrDefault(name, null);
    }

    @Override
    public void addDefinition(VariableRegistry variableRegistry, String name, String value, Definition.OverwritePolicy overwritePolicy) {
        variableRegistry.register(name, value);
        this.addDefinition(name, value, overwritePolicy);
    }

    public void addDefinition(String name, Object value, Definition.OverwritePolicy overwritePolicy) {
        Definition existingDefinition = this.definitions.getOrDefault(name, null);
        if (existingDefinition != null) {
            switch (existingDefinition.overwritePolicy) {
                case NotAllowed: {
                    throw new IllegalStateException("Tried to add definition for " + name + ", but one already existed.");
                }
                case Replace: {
                    this.definitions.remove(name);
                    break;
                }
                case IgnoreNew: {
                    return;
                }
            }
        }
        this.definitions.put(name, new Definition(name, value, overwritePolicy));
    }

    private void addDefinition(String name, Object value) {
        this.addDefinition(name, value, this.definitionOverwritePolicy);
    }

    @Override
    public void setDefinitionPolicy(Definition.OverwritePolicy policy) {
        this.definitionOverwritePolicy = policy;
    }

    public ParseTreeListener getListener() {
        return new RusefiConfigGrammarBaseListener(){
            private int[] arrayDim = null;
            private final Stack<Double> evalStack = new Stack();

            @Override
            public void exitContent(RusefiConfigGrammarParser.ContentContext ctx) {
                assert (ParseState.this.scopes.empty());
                assert (ParseState.this.scope == null);
                assert (ParseState.this.typedefName == null);
                assert (ParseState.this.evalResults.isEmpty());
                assert (this.evalStack.empty());
            }

            @Override
            public void exitDefinition(RusefiConfigGrammarParser.DefinitionContext ctx) {
                String name = ctx.identifier().getText();
                if (ctx.integer() != null) {
                    ParseState.this.handleIntDefinition(name, Integer.parseInt(ctx.integer().getText()));
                } else if (ctx.floatNum() != null) {
                    ParseState.this.addDefinition(name, Double.parseDouble(ctx.floatNum().getText()));
                } else if (ctx.numexpr() != null) {
                    double evalResult = (Double)ParseState.this.evalResults.remove();
                    int floored = (int)Math.floor(evalResult);
                    if (Math.abs((double)floored - evalResult) < 0.001) {
                        ParseState.this.handleIntDefinition(name, floored);
                    } else {
                        ParseState.this.addDefinition(name, evalResult);
                    }
                } else {
                    String defText = ctx.restOfLine().getText();
                    ParseState.this.addDefinition(name, defText);
                    if (CHAR_LITERAL.matcher(defText).find()) {
                        ParseState.this.addDefinition(name + "_char", Character.valueOf(defText.charAt(1)));
                    }
                }
            }

            @Override
            public void enterTypedef(RusefiConfigGrammarParser.TypedefContext ctx) {
                ParseState.this.typedefName = ctx.identifier().getText();
            }

            @Override
            public void exitTypedef(RusefiConfigGrammarParser.TypedefContext ctx) {
                ParseState.this.typedefName = null;
            }

            @Override
            public void exitScalarTypedefSuffix(RusefiConfigGrammarParser.ScalarTypedefSuffixContext ctx) {
                Type datatype = Type.findByTsType(ctx.Datatype().getText());
                FieldOptions options = new FieldOptions();
                this.handleFieldOptionsList(options, ctx.fieldOptionsList());
                ParseState.this.typedefs.put(ParseState.this.typedefName, new ScalarTypedef(ParseState.this.typedefName, datatype, options));
            }

            @Override
            public void enterEnumTypedefSuffix(RusefiConfigGrammarParser.EnumTypedefSuffixContext ctx) {
                int endBit = Integer.parseInt(ctx.integer(1).getText());
                Type datatype = Type.findByTsType(ctx.Datatype().getText());
                String rhs = ctx.enumRhs().getText();
                String[] values = null;
                if (rhs.startsWith("@@")) {
                    String defName = rhs.replaceAll("@", "");
                    if (defName.endsWith("_auto_enum")) {
                        defName = defName.substring(0, defName.length() - 10);
                        values = ParseState.this.resolveEnumValues(defName);
                    } else {
                        Definition def = (Definition)ParseState.this.definitions.get(defName);
                        if (def == null) {
                            throw new RuntimeException("couldn't find definition for " + rhs);
                        }
                        Object value = def.value;
                        if (!(value instanceof String)) {
                            throw new RuntimeException("Found definition for " + rhs + " but it wasn't a string as expected");
                        }
                        rhs = (String)value;
                    }
                }
                if (values == null) {
                    values = (String[])Arrays.stream(rhs.split(",")).map(String::trim).map(s -> s.replaceAll("\"", "")).toArray(String[]::new);
                }
                ParseState.this.typedefs.put(ParseState.this.typedefName, new EnumTypedef(ParseState.this.typedefName, datatype, endBit, values));
            }

            @Override
            public void exitStringTypedefSuffix(RusefiConfigGrammarParser.StringTypedefSuffixContext ctx) {
                Double stringLength = (Double)ParseState.this.evalResults.remove();
                ParseState.this.typedefs.put(ParseState.this.typedefName, new StringTypedef(ParseState.this.typedefName, stringLength.intValue()));
            }

            @Override
            public void enterStruct(RusefiConfigGrammarParser.StructContext ctx) {
                if (ParseState.this.scope != null) {
                    ParseState.this.scopes.push(ParseState.this.scope);
                }
                ParseState.this.scope = new Scope();
            }

            @Override
            public void enterUnionField(RusefiConfigGrammarParser.UnionFieldContext ctx) {
                this.enterStruct(null);
            }

            void handleFieldOptionsList(FieldOptions options, RusefiConfigGrammarParser.FieldOptionsListContext ctx) {
                if (ctx == null) {
                    return;
                }
                if (ctx.fieldOption().size() == 0) {
                    if (ctx.SemicolonedString() != null) {
                        String text = ctx.SemicolonedString().getText();
                        options.comment = text.substring(1, text.length() - 1).trim();
                    } else {
                        options.comment = ctx.SemicolonedSuffix() != null ? ctx.SemicolonedSuffix().getText().substring(1).trim() : "";
                    }
                    if (!ctx.numexpr().isEmpty()) {
                        options.units = ctx.QuotedString().getText();
                        options.scale = (Double)ParseState.this.evalResults.remove();
                        options.offset = (Double)ParseState.this.evalResults.remove();
                        options.min = (Double)ParseState.this.evalResults.remove();
                        options.max = (Double)ParseState.this.evalResults.remove();
                        options.digits = Integer.parseInt(ctx.integer().getText());
                        assert (ParseState.this.evalResults.size() == 0);
                    }
                    return;
                }
                block22: for (RusefiConfigGrammarParser.FieldOptionContext fo : ctx.fieldOption()) {
                    String key = fo.getChild(0).getText();
                    String sValue = fo.getChild(2).getText();
                    switch (key) {
                        case "unit": {
                            options.units = sValue;
                            continue block22;
                        }
                        case "comment": {
                            options.comment = sValue;
                            continue block22;
                        }
                        case "digits": {
                            options.digits = Integer.parseInt(sValue);
                            continue block22;
                        }
                    }
                    Double value = (Double)ParseState.this.evalResults.remove();
                    switch (key) {
                        case "min": {
                            options.min = value;
                            break;
                        }
                        case "max": {
                            options.max = value;
                            break;
                        }
                        case "scale": {
                            options.scale = value;
                            break;
                        }
                        case "offset": {
                            options.offset = value;
                        }
                    }
                }
                assert (ParseState.this.evalResults.size() == 0);
            }

            @Override
            public void exitScalarField(RusefiConfigGrammarParser.ScalarFieldContext ctx) {
                boolean autoscale;
                String type = ctx.identifier(0).getText();
                String name = ctx.identifier(1).getText();
                boolean bl = autoscale = ctx.Autoscale() != null;
                if (ParseState.this.structs.containsKey(type)) {
                    ((ParseState)ParseState.this).scope.structFields.add(new StructField((Struct)ParseState.this.structs.get(type), name));
                    return;
                }
                Typedef typedef = (Typedef)ParseState.this.typedefs.get(type);
                FieldOptions options = null;
                if (typedef != null) {
                    if (typedef instanceof ScalarTypedef) {
                        ScalarTypedef scTypedef = (ScalarTypedef)typedef;
                        options = scTypedef.options.copy();
                        type = scTypedef.type.cType;
                    } else {
                        if (typedef instanceof EnumTypedef) {
                            EnumTypedef bTypedef = (EnumTypedef)typedef;
                            options = new FieldOptions();
                            this.handleFieldOptionsList(options, ctx.fieldOptionsList());
                            ((ParseState)ParseState.this).scope.structFields.add(new EnumField(bTypedef.type, type, name, bTypedef.endBit, bTypedef.values, options));
                            return;
                        }
                        if (typedef instanceof StringTypedef) {
                            options = new FieldOptions();
                            this.handleFieldOptionsList(options, ctx.fieldOptionsList());
                            StringTypedef sTypedef = (StringTypedef)typedef;
                            ((ParseState)ParseState.this).scope.structFields.add(new StringField(name, sTypedef.size, options.comment));
                            return;
                        }
                    }
                } else {
                    if (!Type.findByCtype(type).isPresent()) {
                        throw new RuntimeException("didn't understand type " + type + " for element " + name);
                    }
                    options = new FieldOptions();
                }
                this.handleFieldOptionsList(options, ctx.fieldOptionsList());
                ((ParseState)ParseState.this).scope.structFields.add(new ScalarField(Type.findByCtype(type).get(), name, options, autoscale));
            }

            @Override
            public void enterBitField(RusefiConfigGrammarParser.BitFieldContext ctx) {
                Field lastElement;
                String name = ctx.identifier().getText();
                BitGroup group = null;
                if (!((ParseState)ParseState.this).scope.structFields.isEmpty() && (lastElement = ((ParseState)ParseState.this).scope.structFields.get(((ParseState)ParseState.this).scope.structFields.size() - 1)) instanceof BitGroup) {
                    group = (BitGroup)lastElement;
                    if (group.bitFields.size() == 32) {
                        group = null;
                    }
                }
                if (group == null) {
                    group = new BitGroup();
                    ((ParseState)ParseState.this).scope.structFields.add(group);
                }
                String comment = ctx.SemicolonedSuffix() == null ? null : ctx.SemicolonedSuffix().getText().substring(1).trim();
                String trueValue = "\"true\"";
                String falseValue = "\"false\"";
                if (!ctx.QuotedString().isEmpty()) {
                    trueValue = ctx.QuotedString(0).getText();
                    falseValue = ctx.QuotedString(1).getText();
                }
                group.addBitField(new BitField(name, comment, trueValue, falseValue));
            }

            /*
             * Enabled aggressive block sorting
             */
            @Override
            public void exitArrayField(RusefiConfigGrammarParser.ArrayFieldContext ctx) {
                FieldOptions options;
                boolean autoscale;
                boolean iterate;
                int[] length;
                String name;
                String type;
                block10: {
                    type = ctx.identifier(0).getText();
                    name = ctx.identifier(1).getText();
                    length = this.arrayDim;
                    iterate = ctx.Iterate() != null;
                    boolean bl = autoscale = ctx.Autoscale() != null;
                    if (iterate && length.length != 1) {
                        throw new IllegalStateException("Cannot iterate multi dimensional array: " + name);
                    }
                    if (ParseState.this.structs.containsKey(type)) {
                        assert (iterate);
                        ((ParseState)ParseState.this).scope.structFields.add(new ArrayField<StructField>(new StructField((Struct)ParseState.this.structs.get(type), name), length, iterate));
                        return;
                    }
                    Typedef typedef = (Typedef)ParseState.this.typedefs.get(type);
                    if (typedef != null) {
                        if (typedef instanceof ScalarTypedef) {
                            ScalarTypedef scTypedef = (ScalarTypedef)typedef;
                            options = scTypedef.options.copy();
                            type = scTypedef.type.cType;
                            break block10;
                        } else {
                            if (typedef instanceof EnumTypedef) {
                                EnumTypedef bTypedef = (EnumTypedef)typedef;
                                FieldOptions options2 = new FieldOptions();
                                this.handleFieldOptionsList(options2, ctx.fieldOptionsList());
                                EnumField prototype = new EnumField(bTypedef.type, type, name, bTypedef.endBit, bTypedef.values, options2);
                                ((ParseState)ParseState.this).scope.structFields.add(new ArrayField<EnumField>(prototype, length, iterate));
                                return;
                            }
                            if (!(typedef instanceof StringTypedef)) {
                                throw new RuntimeException("didn't understand type " + type + " for element " + name);
                            }
                            StringTypedef sTypedef = (StringTypedef)typedef;
                            assert (iterate);
                            FieldOptions options3 = new FieldOptions();
                            this.handleFieldOptionsList(options3, ctx.fieldOptionsList());
                            StringField prototype = new StringField(name, sTypedef.size, options3.comment);
                            ((ParseState)ParseState.this).scope.structFields.add(new ArrayField<StringField>(prototype, length, iterate));
                            return;
                        }
                    }
                    if (!Type.findByCtype(type).isPresent()) {
                        throw new RuntimeException("didn't understand type " + type + " for element " + name);
                    }
                    options = new FieldOptions();
                }
                this.handleFieldOptionsList(options, ctx.fieldOptionsList());
                ScalarField prototype = new ScalarField(Type.findByCtype(type).get(), name, options, autoscale);
                ((ParseState)ParseState.this).scope.structFields.add(new ArrayField<ScalarField>(prototype, length, iterate));
            }

            @Override
            public void exitArrayLengthSpec(RusefiConfigGrammarParser.ArrayLengthSpecContext ctx) {
                int arrayDim0 = ((Double)ParseState.this.evalResults.remove()).intValue();
                this.arrayDim = ctx.ArrayDimensionSeparator() != null ? new int[]{arrayDim0, ((Double)ParseState.this.evalResults.remove()).intValue()} : new int[]{arrayDim0};
            }

            @Override
            public void enterUnusedField(RusefiConfigGrammarParser.UnusedFieldContext ctx) {
                ((ParseState)ParseState.this).scope.structFields.add(new UnusedField(Integer.parseInt(ctx.integer().getText())));
            }

            @Override
            public void exitStruct(RusefiConfigGrammarParser.StructContext ctx) {
                String structName = ctx.identifier().getText();
                assert (ParseState.this.scope != null);
                String comment = ctx.restOfLine() == null ? null : ctx.restOfLine().getText();
                Struct s = new Struct(structName, ((ParseState)ParseState.this).scope.structFields, ctx.StructNoPrefix() != null, comment);
                ParseState.this.structs.put(structName, s);
                ParseState.this.structList.add(s);
                ParseState.this.lastStruct = s;
                if (ParseState.this.scopes.empty()) {
                    ParseState.this.scope = null;
                } else {
                    ParseState.this.scope = (Scope)ParseState.this.scopes.pop();
                }
            }

            @Override
            public void exitUnionField(RusefiConfigGrammarParser.UnionFieldContext ctx) {
                assert (ParseState.this.scope != null);
                assert (!((ParseState)ParseState.this).scope.structFields.isEmpty());
                Union u = new Union(((ParseState)ParseState.this).scope.structFields);
                ParseState.this.scope = (Scope)ParseState.this.scopes.pop();
                ((ParseState)ParseState.this).scope.structFields.add(u);
            }

            @Override
            public void exitEvalNumber(RusefiConfigGrammarParser.EvalNumberContext ctx) {
                this.evalStack.push(Double.parseDouble(ctx.floatNum().getText()));
            }

            @Override
            public void exitEvalReplacement(RusefiConfigGrammarParser.EvalReplacementContext ctx) {
                String defName = ctx.getText().replaceAll("@", "");
                if (!ParseState.this.definitions.containsKey(defName)) {
                    throw new RuntimeException("Definition not found for " + ctx.getText());
                }
                Definition def = (Definition)ParseState.this.definitions.get(defName);
                if (!def.isNumeric()) {
                    throw new RuntimeException("Tried to use symbol " + defName + " in an expression, but it wasn't a number");
                }
                this.evalStack.push(def.asDouble());
            }

            @Override
            public void exitEvalMul(RusefiConfigGrammarParser.EvalMulContext ctx) {
                Double right = this.evalStack.pop();
                Double left = this.evalStack.pop();
                this.evalStack.push(left * right);
            }

            @Override
            public void exitEvalDiv(RusefiConfigGrammarParser.EvalDivContext ctx) {
                Double right = this.evalStack.pop();
                Double left = this.evalStack.pop();
                this.evalStack.push(left / right);
            }

            @Override
            public void exitEvalAdd(RusefiConfigGrammarParser.EvalAddContext ctx) {
                Double right = this.evalStack.pop();
                Double left = this.evalStack.pop();
                this.evalStack.push(left + right);
            }

            @Override
            public void exitEvalSub(RusefiConfigGrammarParser.EvalSubContext ctx) {
                Double right = this.evalStack.pop();
                Double left = this.evalStack.pop();
                this.evalStack.push(left - right);
            }

            @Override
            public void exitNumexpr(RusefiConfigGrammarParser.NumexprContext ctx) {
                assert (this.evalStack.size() == 1);
                ParseState.this.evalResults.add(this.evalStack.pop());
            }
        };
    }

    static class Scope {
        public final List<Field> structFields = new ArrayList<Field>();

        Scope() {
        }
    }
}

