/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi.io.stream;

import com.devexperts.logging.Logging;
import com.opensr5.io.DataListener;
import com.rusefi.binaryprotocol.IncomingDataBuffer;
import com.rusefi.io.IoStream;
import com.rusefi.io.can.IsoTpCanDecoder;
import com.rusefi.io.can.IsoTpConnector;
import com.rusefi.io.serial.AbstractIoStream;
import com.rusefi.io.tcp.BinaryProtocolServer;
import java.io.IOException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.jetbrains.annotations.Nullable;
import tel.schich.javacan.CanChannels;
import tel.schich.javacan.CanFrame;
import tel.schich.javacan.CanSocketOptions;
import tel.schich.javacan.NetworkDevice;
import tel.schich.javacan.RawCanChannel;

public class SocketCANIoStream
extends AbstractIoStream {
    static Logging log = Logging.getLogging(SocketCANIoStream.class);
    private final IncomingDataBuffer dataBuffer;
    private final RawCanChannel socket;
    private final IsoTpCanDecoder canDecoder = new IsoTpCanDecoder(){

        @Override
        protected void onTpFirstFrame() {
            SocketCANIoStream.this.sendCanPacket(1.FLOW_CONTROL);
        }
    };
    private final IsoTpConnector isoTpConnector = new IsoTpConnector(){

        @Override
        public void sendCanData(byte[] hdr, byte[] data, int dataOffset, int dataLength) {
            byte[] total = 2.combineArrays(hdr, data, dataOffset, dataLength);
            SocketCANIoStream.this.sendCanPacket(total);
        }

        @Override
        public void receiveData() {
        }
    };

    private void sendCanPacket(byte[] total) {
        if (log.debugEnabled()) {
            log.debug("-------sendIsoTp " + total.length + " byte(s):");
        }
        if (log.debugEnabled()) {
            log.debug("Sending " + IoStream.printHexBinary(total));
        }
        CanFrame packet = CanFrame.create(256, (byte)0, total);
        try {
            this.socket.write(packet);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    public SocketCANIoStream() {
        try {
            NetworkDevice canInterface = NetworkDevice.lookup(System.getProperty("CAN_DEVICE_NAME", "can0"));
            this.socket = CanChannels.newRawChannel();
            this.socket.bind(canInterface);
            this.socket.configureBlocking(true);
            this.socket.setOption(CanSocketOptions.RECV_OWN_MSGS, false);
        }
        catch (IOException e) {
            throw new IllegalStateException("Error looking up", e);
        }
        this.dataBuffer = this.createDataBuffer("[SocketCAN] ");
    }

    @Nullable
    public static SocketCANIoStream create() {
        return new SocketCANIoStream();
    }

    @Override
    public void write(byte[] bytes) throws IOException {
        IsoTpConnector.sendStrategy(bytes, this.isoTpConnector);
    }

    @Override
    public void setInputListener(DataListener listener) {
        ExecutorService threadExecutor = Executors.newSingleThreadExecutor(BinaryProtocolServer.getThreadFactory("SocketCAN reader"));
        threadExecutor.execute(() -> {
            while (!this.isClosed()) {
                this.readOnePacket(listener);
            }
        });
    }

    private void readOnePacket(DataListener listener) {
        try {
            CanFrame rx = this.socket.read();
            if (log.debugEnabled()) {
                log.debug("GOT " + String.format("%X", rx));
            }
            if (rx.getId() != 258) {
                if (log.debugEnabled()) {
                    log.debug("Skipping non " + String.format("%X", 258) + " packet: " + String.format("%X", rx.getId()));
                }
                return;
            }
            byte[] raw = new byte[rx.getDataLength()];
            rx.getData(raw, 0, raw.length);
            byte[] decode = this.canDecoder.decodePacket(raw);
            listener.onDataArrived(decode);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public IncomingDataBuffer getDataBuffer() {
        return this.dataBuffer;
    }

    public static IoStream createStream() {
        return new SocketCANIoStream();
    }
}

