/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi.newparse.outputs;

import com.rusefi.newparse.ParseState;
import com.rusefi.newparse.layout.StructLayout;
import com.rusefi.newparse.outputs.PrintStreamAlwaysUnix;
import com.rusefi.newparse.outputs.TsMetadata;
import com.rusefi.newparse.parsing.Definition;
import java.io.BufferedReader;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintStream;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class TsWriter {
    private static final Pattern VAR = Pattern.compile("@@([a-zA-Z0-9_]+?)@@");
    private static final Pattern OPTIONAL_LINE = Pattern.compile("@@if_([a-zA-Z0-9_]+)");

    public void writeTunerstudio(ParseState parser, String inputFile, String outputFile) throws IOException {
        PrintStreamAlwaysUnix ps = new PrintStreamAlwaysUnix(new FileOutputStream(outputFile));
        this.writeTunerstudio(parser, inputFile, ps);
        ps.close();
    }

    public void writeTunerstudio(ParseState parser, String inputFile, PrintStream ps) throws IOException {
        BufferedReader is = new BufferedReader(new FileReader(inputFile));
        while (is.ready()) {
            String line = is.readLine();
            if (line.contains("CONFIG_DEFINITION_START")) {
                this.writeLayoutAndComments(parser, ps);
                continue;
            }
            Matcher match = OPTIONAL_LINE.matcher(line);
            if (match.find()) {
                String varName = match.group(1);
                Definition def = parser.findDefinition(varName);
                if (def == null || def.toString().equals("false")) continue;
                line = line.replace(match.group(0), "");
            }
            boolean isNested = false;
            while (line.contains("@@")) {
                String replacement;
                match = VAR.matcher(line);
                if (!match.find()) {
                    throw new RuntimeException("Failed to resolve definition in line: " + line);
                }
                String varName = match.group(1);
                Definition def = parser.findDefinition(varName);
                String string = replacement = def != null ? def.toString() : "MISSING DEFINITION";
                while (isNested && replacement.startsWith("\"") && replacement.endsWith("\"")) {
                    replacement = replacement.substring(1, replacement.length() - 1);
                }
                line = line.replaceAll(match.group(0), replacement);
                if (isNested) continue;
                isNested = true;
            }
            ps.println(line);
        }
        is.close();
    }

    public void writeLayoutAndComments(ParseState parser, PrintStream ps) {
        StructLayout root = new StructLayout(0, "root", parser.getLastStruct());
        TsMetadata meta = new TsMetadata();
        int size = root.getSize();
        ps.println("pageSize            = " + size);
        ps.println("page = 1");
        root.writeTunerstudioLayout(ps, meta);
        ps.println("; total TS size = " + size);
        ps.println("[SettingContextHelp]");
        meta.writeComments(ps);
    }
}

