/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi;

import com.rusefi.FileLog;
import com.rusefi.io.LinkManager;
import com.rusefi.io.tcp.TcpConnector;
import com.rusefi.maintenance.DfuFlasher;
import com.rusefi.ui.StatusConsumer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.jetbrains.annotations.NotNull;

public enum SerialPortScanner {
    INSTANCE;

    private volatile boolean isRunning = true;
    private static final boolean SHOW_SOCKETCAN;
    static final String AUTO_SERIAL = "Auto Serial";
    private final Object lock = new Object();
    @NotNull
    private AvailableHardware knownHardware = new AvailableHardware(Collections.emptyList(), false, false, false);
    private final List<Listener> listeners = new CopyOnWriteArrayList<Listener>();

    public void addListener(Listener listener) {
        boolean shouldStart = this.listeners.isEmpty();
        this.listeners.add(listener);
        if (shouldStart) {
            this.startTimer();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void findAllAvailablePorts(boolean includeSlowLookup) {
        boolean isListUpdated;
        boolean PCANConnected;
        boolean stLinkConnected;
        boolean dfuConnected;
        ArrayList<String> ports = new ArrayList<String>();
        String[] serialPorts = LinkManager.getCommPorts();
        if (serialPorts.length > 0) {
            ports.add(AUTO_SERIAL);
        }
        ports.addAll(Arrays.asList(serialPorts));
        if (includeSlowLookup) {
            ports.addAll(TcpConnector.getAvailablePorts());
            dfuConnected = DfuFlasher.detectSTM32BootloaderDriverState(StatusConsumer.VOID);
            stLinkConnected = DfuFlasher.detectStLink(StatusConsumer.VOID);
            PCANConnected = DfuFlasher.detectPcan(StatusConsumer.VOID);
        } else {
            dfuConnected = false;
            stLinkConnected = false;
            PCANConnected = false;
        }
        if (PCANConnected) {
            ports.add("PCAN");
        }
        if (SHOW_SOCKETCAN) {
            ports.add("SocketCAN");
        }
        AvailableHardware currentHardware = new AvailableHardware(ports, dfuConnected, stLinkConnected, PCANConnected);
        Iterator<Listener> iterator = this.lock;
        synchronized (iterator) {
            isListUpdated = !this.knownHardware.equals(currentHardware);
            this.knownHardware = currentHardware;
        }
        if (isListUpdated) {
            for (Listener listener : this.listeners) {
                listener.onChange(currentHardware);
            }
        }
    }

    private void startTimer() {
        Thread portsScanner = new Thread(() -> {
            boolean isFirstTime = true;
            while (this.isRunning) {
                this.findAllAvailablePorts(!isFirstTime);
                isFirstTime = false;
                try {
                    Thread.sleep(300L);
                }
                catch (InterruptedException e) {
                    throw new IllegalStateException(e);
                }
            }
        }, "Ports Scanner");
        portsScanner.setDaemon(true);
        portsScanner.start();
    }

    public void stopTimer() {
        this.isRunning = false;
    }

    static {
        SHOW_SOCKETCAN = FileLog.isLinux();
    }

    public static class AvailableHardware {
        private final List<String> ports;
        private final boolean dfuFound;
        private final boolean stLinkConnected;
        private final boolean PCANConnected;

        public <T> AvailableHardware(List<String> ports, boolean dfuFound, boolean stLinkConnected, boolean PCANConnected) {
            this.ports = ports;
            this.dfuFound = dfuFound;
            this.stLinkConnected = stLinkConnected;
            this.PCANConnected = PCANConnected;
        }

        @NotNull
        public List<String> getKnownPorts() {
            return new ArrayList<String>(this.ports);
        }

        public boolean isDfuFound() {
            return this.dfuFound;
        }

        public boolean isStLinkConnected() {
            return this.stLinkConnected;
        }

        public boolean isPCANConnected() {
            return this.PCANConnected;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            AvailableHardware that = (AvailableHardware)o;
            return this.dfuFound == that.dfuFound && this.stLinkConnected == that.stLinkConnected && this.PCANConnected == that.PCANConnected && this.ports.equals(that.ports);
        }

        public boolean isEmpty() {
            return !this.dfuFound && !this.stLinkConnected && !this.PCANConnected && this.ports.isEmpty();
        }
    }

    static interface Listener {
        public void onChange(AvailableHardware var1);
    }
}

