/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi.ui.etb;

import com.rusefi.core.MessagesCentral;
import com.rusefi.core.Sensor;
import com.rusefi.core.SensorCentral;
import com.rusefi.io.InvocationConfirmationListener;
import com.rusefi.ui.UIContext;
import java.awt.event.ActionEvent;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.putgemin.VerticalFlowLayout;

public class MagicSpotsFinder {
    private static final long SLEEP = 1000L;
    private static final double DUTY_CYCLE_STEP = 0.5;
    private static final String MAGIC_SPOTS_FINDER = "Magic Spots Finder";
    private static final int INITIAL_SLEEP = 10000;
    private final JButton button = new JButton("Magic Spots Finder");
    private final ScheduledExecutorService executor = Executors.newSingleThreadScheduledExecutor();
    private static final double MEASURMENT_PRECISION = 0.5;
    private final UIContext uiContext;
    private double defaultTpsPosition;
    private State state;
    private double currentDutyCycle;
    private double startedToOpenValue;
    private double reached100Value;
    private double startedToCloseValue;
    private double backToZeroValue;
    private final JPanel points = new JPanel(new VerticalFlowLayout());
    private final JLabel startedToOpenValueLabel = new JLabel("n/a");
    private final JLabel reached100ValueLabel = new JLabel("n/a");
    private final JLabel startedToCloseValueLabel = new JLabel("n/a");
    private final JLabel backToZeroValueLabel = new JLabel("n/a");
    private final InvocationConfirmationListener goingDown = new InvocationConfirmationListener(){

        @Override
        public void onCommandConfirmation() {
            MagicSpotsFinder.this.state = State.GOING_DOWN;
            MagicSpotsFinder.this.executor.execute(new Runnable(){

                @Override
                public void run() {
                    MagicSpotsFinder.this.sleep(1000L);
                    double tpsPosition = SensorCentral.getInstance().getValue(Sensor.TPS);
                    MessagesCentral.getInstance().postMessage(this.getClass(), "ETB duty " + MagicSpotsFinder.this.currentDutyCycle + ": tps=" + tpsPosition);
                    if (tpsPosition >= 99.5) {
                        MagicSpotsFinder.this.currentDutyCycle = MagicSpotsFinder.this.currentDutyCycle - 0.5;
                        MagicSpotsFinder.this.uiContext.getCommandQueue().write("set_etb_duty " + MagicSpotsFinder.this.currentDutyCycle, MagicSpotsFinder.this.goingDown);
                    } else if (tpsPosition > MagicSpotsFinder.this.defaultTpsPosition + 0.5) {
                        if (MagicSpotsFinder.this.startedToCloseValue == 0.0) {
                            MagicSpotsFinder.this.startedToCloseValue = MagicSpotsFinder.this.currentDutyCycle;
                            MagicSpotsFinder.this.startedToCloseValueLabel.setText(String.format("Started Close %.1f", MagicSpotsFinder.this.startedToCloseValue));
                            MessagesCentral.getInstance().postMessage(this.getClass(), "Started to close at " + MagicSpotsFinder.this.startedToCloseValue);
                        }
                        MagicSpotsFinder.this.currentDutyCycle = MagicSpotsFinder.this.currentDutyCycle - 0.5;
                        MagicSpotsFinder.this.uiContext.getCommandQueue().write("set_etb_duty " + MagicSpotsFinder.this.currentDutyCycle, MagicSpotsFinder.this.goingDown);
                    } else {
                        MagicSpotsFinder.this.backToZeroValue = MagicSpotsFinder.this.currentDutyCycle;
                        MagicSpotsFinder.this.backToZeroValueLabel.setText(String.format("Back Zero %.1f", MagicSpotsFinder.this.backToZeroValue));
                        MessagesCentral.getInstance().postMessage(this.getClass(), "Back closed to close at " + MagicSpotsFinder.this.backToZeroValue);
                        MessagesCentral.getInstance().postMessage(this.getClass(), "startedToOpenValue = " + MagicSpotsFinder.this.startedToOpenValue + ", reached100Value = " + MagicSpotsFinder.this.reached100Value);
                        MessagesCentral.getInstance().postMessage(this.getClass(), "startedToCloseValue = " + MagicSpotsFinder.this.startedToCloseValue + ", backToZeroValue = " + MagicSpotsFinder.this.backToZeroValue);
                        MagicSpotsFinder.this.button.setEnabled(true);
                        MagicSpotsFinder.this.button.setText(MagicSpotsFinder.MAGIC_SPOTS_FINDER);
                    }
                }
            });
        }
    };
    private final InvocationConfirmationListener goingUp = new InvocationConfirmationListener(){

        @Override
        public void onCommandConfirmation() {
            MagicSpotsFinder.this.state = State.GOING_UP;
            MagicSpotsFinder.this.executor.execute(new Runnable(){

                @Override
                public void run() {
                    MagicSpotsFinder.this.sleep(1000L);
                    double tpsPosition = SensorCentral.getInstance().getValue(Sensor.TPS);
                    MessagesCentral.getInstance().postMessage(this.getClass(), "ETB duty " + MagicSpotsFinder.this.currentDutyCycle + ": tps=" + tpsPosition);
                    if (tpsPosition < MagicSpotsFinder.this.defaultTpsPosition + 0.5) {
                        MagicSpotsFinder.this.currentDutyCycle = MagicSpotsFinder.this.currentDutyCycle + 0.5;
                        MagicSpotsFinder.this.uiContext.getCommandQueue().write("set_etb_duty " + MagicSpotsFinder.this.currentDutyCycle, MagicSpotsFinder.this.goingUp);
                    } else if (tpsPosition < 99.5) {
                        if (MagicSpotsFinder.this.startedToOpenValue == 0.0) {
                            MagicSpotsFinder.this.startedToOpenValue = MagicSpotsFinder.this.currentDutyCycle;
                            MagicSpotsFinder.this.startedToOpenValueLabel.setText(String.format("Start to open: %.1f", MagicSpotsFinder.this.startedToOpenValue));
                            MessagesCentral.getInstance().postMessage(this.getClass(), "Started to open at " + MagicSpotsFinder.this.startedToOpenValue);
                        }
                        MagicSpotsFinder.this.currentDutyCycle = MagicSpotsFinder.this.currentDutyCycle + 0.5;
                        MagicSpotsFinder.this.uiContext.getCommandQueue().write("set_etb_duty " + MagicSpotsFinder.this.currentDutyCycle, MagicSpotsFinder.this.goingUp);
                    } else {
                        MagicSpotsFinder.this.reached100Value = MagicSpotsFinder.this.currentDutyCycle;
                        MagicSpotsFinder.this.reached100ValueLabel.setText(String.format("Reached 100: %.1f", MagicSpotsFinder.this.reached100Value));
                        MessagesCentral.getInstance().postMessage(this.getClass(), "startedToOpenValue = " + MagicSpotsFinder.this.startedToOpenValue + ", reached100Value = " + MagicSpotsFinder.this.reached100Value);
                        MagicSpotsFinder.this.currentDutyCycle = MagicSpotsFinder.this.currentDutyCycle - 0.5;
                        MagicSpotsFinder.this.uiContext.getCommandQueue().write("set_etb_duty " + MagicSpotsFinder.this.currentDutyCycle, MagicSpotsFinder.this.goingDown);
                    }
                }
            });
        }
    };
    private InvocationConfirmationListener setDebugModeConfiguration = new InvocationConfirmationListener(){

        @Override
        public void onCommandConfirmation() {
            MagicSpotsFinder.this.executor.execute(new Runnable(){

                @Override
                public void run() {
                    MagicSpotsFinder.this.state = State.START;
                    MessagesCentral.getInstance().postMessage(this.getClass(), "Start!");
                    MagicSpotsFinder.this.resetValues();
                    MagicSpotsFinder.this.uiContext.getCommandQueue().write("set_etb_duty " + MagicSpotsFinder.this.currentDutyCycle, MagicSpotsFinder.this.goingUp);
                    MagicSpotsFinder.this.sleep(10000L);
                    MagicSpotsFinder.this.defaultTpsPosition = SensorCentral.getInstance().getValue(Sensor.TPS);
                }
            });
        }
    };

    public JPanel getPoints() {
        return this.points;
    }

    private void resetValues() {
        this.currentDutyCycle = 0.5;
        this.startedToOpenValue = 0.0;
        this.reached100Value = 0.0;
        this.startedToCloseValue = 0.0;
        this.backToZeroValue = 0.0;
    }

    public MagicSpotsFinder(final UIContext uiContext) {
        this.uiContext = uiContext;
        this.points.add(this.startedToOpenValueLabel);
        this.points.add(this.reached100ValueLabel);
        this.points.add(this.startedToCloseValueLabel);
        this.points.add(this.backToZeroValueLabel);
        this.button.addActionListener(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MagicSpotsFinder.this.button.setEnabled(false);
                MagicSpotsFinder.this.button.setText("Running...");
                MagicSpotsFinder.this.executor.execute(new Runnable(){

                    @Override
                    public void run() {
                        MagicSpotsFinder.this.state = State.DEBUG_MODE;
                        uiContext.getCommandQueue().write("set debug_mode 29", MagicSpotsFinder.this.setDebugModeConfiguration);
                    }
                });
            }
        });
    }

    public JComponent getButton() {
        return this.button;
    }

    private void sleep(long millis) {
        try {
            MessagesCentral.getInstance().postMessage(this.getClass(), "Sleeping " + millis + "ms");
            Thread.sleep(millis);
        }
        catch (InterruptedException unexpected) {
            unexpected.printStackTrace();
            throw new IllegalStateException(unexpected);
        }
    }

    private static enum State {
        DEBUG_MODE,
        START,
        GOING_UP,
        GOING_DOWN;

    }
}

