/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi.test;

import com.rusefi.DataBuffer;
import com.rusefi.TimeBasedBuffer;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicLong;
import org.junit.Assert;
import org.junit.Test;

public class TimeBasedBufferTest {
    @Test
    public void testRealTruncate() throws InterruptedException {
        TimeBasedBuffer b = new TimeBasedBuffer(100L);
        b.add(1.0);
        System.out.println(b.getSize());
        b.add(2.0);
        b.add(1.0);
        System.out.println(b.getSize());
        Thread.sleep(200L);
        Assert.assertEquals(0L, b.getSize());
    }

    @Test
    public void testTruncate() {
        final AtomicLong time = new AtomicLong();
        TimeBasedBuffer b = new TimeBasedBuffer(100L){

            @Override
            protected long currentTimeMillis() {
                return time.get();
            }
        };
        b.add(1.0);
        Assert.assertEquals(1L, b.getSize());
        b.add(2.0);
        Assert.assertEquals(1L, b.getSize());
        time.set(3L);
        b.add(3.0);
        Assert.assertEquals(2L, b.getSize());
        double[] v = b.getValues();
        Assert.assertTrue(Arrays.equals(new double[]{2.0, 3.0}, v));
        Assert.assertEquals(0.707106, DataBuffer.getStandardDeviation(b.getValues()), 0.001);
        time.set(150L);
        Assert.assertEquals(0L, b.getSize());
    }
}

