/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi.output;

import com.rusefi.ReaderStateImpl;
import com.rusefi.VariableRegistry;
import com.rusefi.output.BaseCHeaderConsumer;
import com.rusefi.util.LazyFile;
import com.rusefi.util.SystemOut;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;

public class CHeaderConsumer
extends BaseCHeaderConsumer {
    @NotNull
    private final ReaderStateImpl state;
    private final boolean withC_Defines;
    private final LazyFile cHeader;
    private final VariableRegistry variableRegistry;

    public CHeaderConsumer(ReaderStateImpl state, String destCHeader, boolean withC_Defines) {
        this.variableRegistry = state.getVariableRegistry();
        this.state = state;
        this.withC_Defines = withC_Defines;
        SystemOut.println("Writing C header to " + destCHeader);
        this.cHeader = new LazyFile(destCHeader);
        this.cHeader.write("// this section " + state.getHeader() + "\n");
        this.cHeader.write("// by " + this.getClass() + "\n");
        this.cHeader.write("// begin\n");
        this.cHeader.write("#pragma once\n");
        this.cHeader.write("#include \"rusefi_types.h\"\n");
    }

    @Override
    public void endFile() throws IOException {
        if (this.withC_Defines) {
            this.cHeader.write(this.variableRegistry.getDefinesSection());
        }
        this.cHeader.write(this.getContent().toString());
        this.cHeader.write("// end\n");
        this.cHeader.write("// this section " + this.state.getHeader() + "\n");
        this.cHeader.close();
    }
}

