/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi.models;

import com.rusefi.FileLog;
import java.io.IOException;
import java.io.Writer;
import java.util.Map;
import java.util.NavigableSet;
import java.util.TreeMap;

public class YAxisData {
    private final TreeMap<Double, ValuesHolder> values = new TreeMap();
    private double maxYValue = Double.MIN_VALUE;
    private double minYValue = Double.MAX_VALUE;
    private final double x;

    public YAxisData(double x) {
        this.x = x;
    }

    public double getX() {
        return this.x;
    }

    public NavigableSet<Double> getYs() {
        return this.values.navigableKeySet();
    }

    public float findZ(double y) {
        Map.Entry<Double, ValuesHolder> entry = this.values.floorEntry(y);
        if (entry != null) {
            return entry.getValue().get();
        }
        return this.values.ceilingEntry(y).getValue().get();
    }

    public void setValue(double y, float value) {
        ValuesHolder holder = this.getHolder(y);
        holder.set(value);
    }

    public void addValue(double y, float value) {
        ValuesHolder holder = this.getHolder(y);
        holder.add(value);
        float newAvg = holder.get();
        if (newAvg != value && !Float.isNaN(newAvg)) {
            FileLog.MAIN.logLine("new " + value + " avg " + newAvg + " for x=" + this.x + "/y=" + y);
        }
    }

    private ValuesHolder getHolder(double y) {
        this.minYValue = Math.min(this.minYValue, y);
        this.maxYValue = Math.max(this.maxYValue, y);
        ValuesHolder holder = this.values.get(y);
        if (holder == null) {
            holder = new ValuesHolder();
            this.values.put(y, holder);
        }
        return holder;
    }

    public double getValue(double y) {
        return this.values.get(y).get();
    }

    public String toString() {
        return "YAxisData{size=" + this.values.size() + ", maxYValue=" + this.maxYValue + ", minYValue=" + this.minYValue + ", x=" + this.x + '}';
    }

    public void write(Writer w) throws IOException {
        for (Map.Entry<Double, ValuesHolder> e : this.values.entrySet()) {
            w.write("rpm," + this.x + ",key," + e.getKey() + ",value," + e.getValue().get() + "\r\n");
        }
    }

    private static class ValuesHolder {
        private float total;
        private int count;

        private ValuesHolder() {
        }

        public float get() {
            return this.total / (float)this.count;
        }

        public void add(float value) {
            this.total += value;
            ++this.count;
        }

        public void set(float value) {
            this.total = value;
            this.count = 1;
        }
    }
}

