/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi.io.can;

import com.devexperts.logging.Logging;
import com.rusefi.io.IoStream;
import org.jetbrains.annotations.NotNull;

public abstract class IsoTpConnector {
    private static final Logging log = Logging.getLogging(IsoTpConnector.class);

    public static void sendStrategy(byte[] bytes, IsoTpConnector connector) {
        int len;
        log.info("-------sendBytesToCan " + bytes.length + " byte(s):");
        log.info(IoStream.printHexBinary(bytes));
        if (bytes.length <= 7) {
            connector.sendCanFrame(0 | bytes.length, bytes, 0, bytes.length);
            return;
        }
        connector.sendCanFrame(0x10 | bytes.length >> 8 & 0xF, bytes.length & 0xFF, bytes, 0, 6);
        connector.receiveData();
        int idx = 1;
        int offset = 6;
        for (int remaining = bytes.length - 6; remaining > 0; remaining -= len) {
            len = Math.min(remaining, 7);
            connector.sendCanFrame(0x20 | idx++ & 0xF, bytes, offset, len);
            offset += len;
        }
    }

    @NotNull
    public static byte[] combineArrays(byte[] hdr, byte[] data, int dataOffset, int dataLength) {
        byte[] total = new byte[hdr.length + dataLength];
        System.arraycopy(hdr, 0, total, 0, hdr.length);
        System.arraycopy(data, dataOffset, total, hdr.length, dataLength);
        return total;
    }

    public void sendCanFrame(int hdr0, byte[] data, int offset, int dataLength) {
        this.sendCanData(new byte[]{(byte)hdr0}, data, offset, dataLength);
    }

    public void sendCanFrame(int hdr0, int hdr1, byte[] data, int dataOffset, int dataLength) {
        this.sendCanData(new byte[]{(byte)hdr0, (byte)hdr1}, data, dataOffset, dataLength);
    }

    public abstract void sendCanData(byte[] var1, byte[] var2, int var3, int var4);

    public abstract void receiveData();
}

