/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi.io;

import com.opensr5.io.DataListener;
import com.opensr5.io.WriteStream;
import com.rusefi.binaryprotocol.BinaryProtocol;
import com.rusefi.binaryprotocol.IncomingDataBuffer;
import com.rusefi.binaryprotocol.IoHelper;
import com.rusefi.io.serial.AbstractIoStream;
import com.rusefi.io.serial.StreamStatistics;
import com.rusefi.io.tcp.BinaryProtocolServer;
import java.io.Closeable;
import java.io.EOFException;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;

public interface IoStream
extends WriteStream,
Closeable,
StreamStatistics {
    public static String printHexBinary(byte[] data) {
        if (data == null) {
            return "(null)";
        }
        char[] hexCode = "0123456789ABCDEF".toCharArray();
        StringBuilder r = new StringBuilder(data.length * 2);
        for (byte b : data) {
            r.append(hexCode[b >> 4 & 0xF]);
            r.append(hexCode[b & 0xF]);
            r.append(' ');
        }
        return r.toString();
    }

    public static String printByteArray(byte[] data) {
        StringBuilder sb = new StringBuilder();
        for (byte b : data) {
            if (Character.isJavaIdentifierPart(b)) {
                sb.append((char)b);
                continue;
            }
            sb.append(' ');
        }
        return IoStream.printHexBinary(data) + sb;
    }

    @NotNull
    default public BinaryProtocolServer.Packet readPacket() throws IOException {
        short length = this.readShort();
        return BinaryProtocolServer.readPromisedBytes(this.getDataBuffer(), (int)length);
    }

    default public void sendPacket(BinaryProtocolServer.Packet packet) throws IOException {
        this.writeShort(packet.getPacket().length);
        this.write(packet.getPacket());
        this.writeInt(packet.getCrc());
        this.flush();
        this.onActivity();
    }

    public long latestActivityTime();

    public void onActivity();

    default public void sendPacket(byte[] plainPacket) throws IOException {
        if (plainPacket.length == 0) {
            throw new IllegalArgumentException("Empty packets are not valid.");
        }
        byte[] packet = BinaryProtocol.PLAIN_PROTOCOL ? plainPacket : IoHelper.makeCrc32Packet(plainPacket);
        this.write(packet);
        this.flush();
    }

    public void setInputListener(DataListener var1);

    public boolean isClosed();

    public AbstractIoStream.StreamStats getStreamStats();

    @Override
    public void close();

    public IncomingDataBuffer getDataBuffer();

    default public short readShort() throws EOFException {
        return this.getDataBuffer().readShort();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    default public byte[] sendAndGetPacket(byte[] packet, String message) throws IOException {
        IoStream ioStream = this;
        synchronized (ioStream) {
            this.sendPacket(packet);
            return this.getDataBuffer().getPacket(message);
        }
    }
}

