/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi.binaryprotocol.test;

import com.macfaq.io.LittleEndianOutputStream;
import com.rusefi.CompatibleFunction;
import com.rusefi.Listener;
import com.rusefi.binaryprotocol.BinaryProtocol;
import com.rusefi.binaryprotocol.IncomingDataBuffer;
import com.rusefi.config.generated.Fields;
import com.rusefi.config.generated.TsOutputs;
import com.rusefi.io.IoStream;
import com.rusefi.io.commands.ByteRange;
import com.rusefi.io.commands.HelloCommand;
import com.rusefi.io.tcp.BinaryProtocolServer;
import com.rusefi.io.tcp.TcpIoStream;
import com.rusefi.ui.StatusConsumer;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.Socket;

public class TcpServerSandbox {
    private static final byte[] TOTALLY_EMPTY_CONFIGURATION = new byte[22368];

    public static void main(String[] args) throws IOException {
        Listener<Object> serverSocketCreationCallback = parameter -> System.out.println("serverSocketCreationCallback");
        CompatibleFunction<Socket, Runnable> socketRunnableFactory = new CompatibleFunction<Socket, Runnable>(){

            @Override
            public Runnable apply(final Socket socket) {
                System.out.println("New connection!");
                return new Runnable(){

                    @Override
                    public void run() {
                        System.out.println("Run server socket: " + socket);
                        EcuState ecuState = new EcuState();
                        try {
                            TcpIoStream stream = new TcpIoStream(TcpServerSandbox.class.getSimpleName(), socket);
                            IncomingDataBuffer in = stream.getDataBuffer();
                            while (!socket.isClosed()) {
                                TcpServerSandbox.handleCommand(ecuState, stream, in, socket);
                                ecuState.onCommand();
                            }
                        }
                        catch (Exception e) {
                            System.out.println("huh exception: " + e);
                            e.printStackTrace();
                        }
                    }
                };
            }
        };
        BinaryProtocolServer.tcpServerSocket(29001, "server", socketRunnableFactory, serverSocketCreationCallback, StatusConsumer.ANONYMOUS);
    }

    private static void handleCommand(EcuState ecuState, IoStream stream, IncomingDataBuffer in, Socket socket) throws IOException {
        Integer length = BinaryProtocolServer.getPendingPacketLengthOrHandleProtocolCommand(socket, new BinaryProtocolServer.Context(), in);
        if (length == null) {
            return;
        }
        byte[] payload = BinaryProtocolServer.getPacketContent(in, length);
        byte command = payload[0];
        if (command == 83) {
            new HelloCommand("rusEFI lts-2023.01.2023.01.22.hellen121vag.21411089").handle(stream);
        } else if (command == 70) {
            stream.sendPacket("\u0000001".getBytes());
        } else if (command == 80) {
            stream.sendPacket("\u0000".getBytes());
        } else if (command == 107) {
            stream.sendPacket(BinaryProtocolServer.createCrcResponse(TOTALLY_EMPTY_CONFIGURATION));
        } else if (command == 108) {
            if (payload[1] == 3) {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                baos.write("\u0000".charAt(0));
                LittleEndianOutputStream dout = new LittleEndianOutputStream(baos);
                int count = 256;
                dout.writeShort(count * 5);
                for (int i = 0; i < count; ++i) {
                    baos.write(i);
                    baos.write(0);
                    baos.write(0);
                    baos.write(0);
                    baos.write(100);
                }
                stream.sendPacket(baos.toByteArray());
            } else {
                stream.sendPacket("\u0000".getBytes());
            }
        } else if (command == 79) {
            byte[] response = BinaryProtocolServer.getOutputCommandResponse(payload, ecuState.outputs);
            stream.sendPacket(response);
        } else if (command == 57) {
            int startOffset = Fields.HIGHSPEEDOFFSETS.getOffset();
            int totalResponseSize = 0;
            for (int i = 0; i < 32; ++i) {
                int higherByte = TcpServerSandbox.getByte(startOffset + 1);
                int type = higherByte >> 5;
                int size = TcpServerSandbox.getSize(type);
                totalResponseSize += size;
                int twoBytes = TcpServerSandbox.getByte(startOffset) + (higherByte & 0x1F) * 256;
                startOffset += 2;
            }
            byte[] response = new byte[1 + totalResponseSize];
            response[0] = (byte)"\u0000".charAt(0);
            stream.sendPacket(response);
        } else if (command == 67) {
            ByteRange byteRange = ByteRange.valueOf(payload);
            System.out.println("TS_CHUNK_WRITE_COMMAND " + byteRange + " payload " + payload.length);
            System.arraycopy(payload, 5, TOTALLY_EMPTY_CONFIGURATION, byteRange.getOffset(), byteRange.getCount());
            stream.sendPacket("\u0000".getBytes());
        } else if (command == 66) {
            stream.sendPacket(new byte[]{4});
        } else if (command == 82) {
            ByteRange byteRange = ByteRange.valueOf(payload);
            int count = byteRange.getCount();
            byte[] response = new byte[1 + count];
            response[0] = (byte)"\u0000".charAt(0);
            stream.sendPacket(response);
        } else if (command == 86) {
            stream.sendPacket("\u0000rusEFI proxy".getBytes());
        } else {
            throw new UnsupportedOperationException("Unsupported command " + BinaryProtocol.findCommand(command));
        }
    }

    private static int getSize(int type) {
        if (type == 0) {
            return 0;
        }
        return 1 << type - 1;
    }

    private static int getByte(int startOffset) {
        return TOTALLY_EMPTY_CONFIGURATION[startOffset] & 0xFF;
    }

    static class EcuState {
        private final byte[] outputs = new byte[1300];
        long startUpTime = System.currentTimeMillis();

        EcuState() {
        }

        public void onCommand() {
            int seconds = (int)((System.currentTimeMillis() - this.startUpTime) / 1000L);
            TsOutputs.SECONDS.setValueU32(this.outputs, seconds);
        }
    }
}

