/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi.ui.etb;

import com.rusefi.config.generated.Fields;
import com.rusefi.core.Sensor;
import com.rusefi.core.preferences.storage.Node;
import com.rusefi.ui.UIContext;
import com.rusefi.ui.config.BitConfigField;
import com.rusefi.ui.config.ConfigUiField;
import com.rusefi.ui.config.EnumConfigField;
import com.rusefi.ui.etb.DirectDrivePanel;
import com.rusefi.ui.etb.EtbMonteCarloSequence;
import com.rusefi.ui.etb.EtbReturnToNeutral;
import com.rusefi.ui.etb.EtbTestSequence;
import com.rusefi.ui.etb.MagicSpotsFinder;
import com.rusefi.ui.util.UiUtils;
import com.rusefi.ui.widgets.AnyCommand;
import com.rusefi.ui.widgets.DetachedSensor;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.jetbrains.annotations.NotNull;
import org.putgemin.VerticalFlowLayout;

public class EtbCommandsPanel {
    private final JPanel content = new JPanel(new VerticalFlowLayout());
    private final UIContext uiContext;

    public EtbCommandsPanel(UIContext uiContext) {
        this.uiContext = uiContext;
        this.content.add(new DirectDrivePanel(uiContext).getContent());
        JPanel testParameters = new JPanel(new VerticalFlowLayout());
        testParameters.setBorder(BorderFactory.createTitledBorder("Try PID settings"));
        EtbTestSequence etbTestSequence = new EtbTestSequence(uiContext);
        testParameters.add(etbTestSequence.getButton());
        testParameters.add(UiUtils.wrap(etbTestSequence.getCancelButton()));
        testParameters.add(etbTestSequence.getResult());
        testParameters.add(new JLabel("To change setting use following commands:"));
        testParameters.add(new JLabel("set etb_p X"));
        testParameters.add(new JLabel("set etb_i X"));
        testParameters.add(new JLabel("set etb_d X"));
        testParameters.add(new JLabel("set etb_o X"));
        testParameters.add(new JLabel("For example:"));
        testParameters.add(new JLabel("set etb_p 1.1"));
        testParameters.add(new BitConfigField(uiContext, Fields.PAUSEETBCONTROL, "Pause").getContent());
        testParameters.add(new ConfigUiField(uiContext, Fields.ETB_PFACTOR, "pFactor").getContent());
        testParameters.add(new ConfigUiField(uiContext, Fields.ETB_IFACTOR, "iFactor").getContent());
        testParameters.add(new ConfigUiField(uiContext, Fields.ETB_DFACTOR, "dFactor").getContent());
        this.content.setBorder(BorderFactory.createTitledBorder("Commands"));
        this.content.add(testParameters);
        this.content.add(AnyCommand.createArea(uiContext, new Node(), "set_etb_duty 10", false, false).getContent());
        JPanel mockPpsPanel = new JPanel(new VerticalFlowLayout());
        mockPpsPanel.setBorder(BorderFactory.createTitledBorder("Mock PPS"));
        mockPpsPanel.add(DetachedSensor.createMockVoltageSlider(uiContext.getCommandQueue(), Sensor.PPS));
        this.content.add(mockPpsPanel);
        this.content.add(new EnumConfigField(uiContext, Fields.DEBUGMODE, "Debug Mode").getContent());
        this.content.add(this.createMagicSpotsPanel());
        this.content.add(UiUtils.wrap(new EtbMonteCarloSequence(uiContext).getButton()));
        this.content.add(UiUtils.wrap(new EtbReturnToNeutral(uiContext).getContent()));
    }

    @NotNull
    private JPanel createMagicSpotsPanel() {
        JPanel spotsPane = new JPanel(new VerticalFlowLayout());
        spotsPane.setBorder(BorderFactory.createTitledBorder("Magic Spots"));
        MagicSpotsFinder magicSpotsFinder = new MagicSpotsFinder(this.uiContext);
        spotsPane.add(UiUtils.wrap(magicSpotsFinder.getButton()));
        spotsPane.add(magicSpotsFinder.getPoints());
        return spotsPane;
    }

    public JComponent getContent() {
        return new JScrollPane(this.content, 22, 30);
    }
}

