/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi.etb;

import com.rusefi.FileLog;
import com.rusefi.core.MessagesCentral;
import com.rusefi.etb.EtbTarget;
import com.rusefi.ui.UIContext;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

public abstract class TestSequenceStep {
    protected final long nextStepDelay;
    private final Condition condition;
    private TestSequenceStep next;

    public TestSequenceStep(long nextStepDelay, Condition condition) {
        this.nextStepDelay = nextStepDelay;
        this.condition = condition;
    }

    public static int count(TestSequenceStep step) {
        int result = 0;
        while ((step = step.getNext()) != null) {
            ++result;
        }
        return result;
    }

    public void execute(ScheduledExecutorService executor) {
        boolean shouldRun = this.condition.shouldRunTask();
        if (shouldRun) {
            this.doJob();
        }
        if (this.next != null) {
            if (shouldRun) {
                FileLog.MAIN.logLine("Scheduling " + this.next + " with " + this.nextStepDelay + "ms delay");
                executor.schedule(() -> this.next.execute(executor), this.nextStepDelay, TimeUnit.MILLISECONDS);
            } else {
                this.next.execute(executor);
            }
        } else {
            MessagesCentral.getInstance().postMessage(TestSequenceStep.class, "ETB test sequence done!");
        }
    }

    protected abstract void doJob();

    public TestSequenceStep addNext(UIContext uiContext, long duration, double position, Runnable onEachStep, Condition condition) {
        return this.addNext(new EtbTarget(uiContext, duration, position, onEachStep, condition));
    }

    public TestSequenceStep addNext(TestSequenceStep step) {
        this.next = step;
        return this.next;
    }

    public TestSequenceStep getNext() {
        return this.next;
    }

    public static interface Condition {
        public static final Condition YES = () -> true;

        public boolean shouldRunTask();
    }
}

