/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi.enum_reader;

import com.rusefi.VariableRegistry;
import java.util.Objects;

public class Value
implements Comparable<Value> {
    private final String name;
    private final String value;

    public Value(String name, String value) {
        this.name = name;
        this.value = value;
    }

    public boolean isForceSize() {
        return this.getName().startsWith("Force_2_bytes_size") || this.getName().startsWith("Force_4_bytes_size");
    }

    public String getName() {
        return this.name;
    }

    public String getValue() {
        return this.value;
    }

    public int getIntValue() {
        return Integer.parseInt(this.value);
    }

    @Override
    public int compareTo(Value o) {
        return this.name.compareTo(o.name);
    }

    public String toString() {
        return "Value{name='" + this.name + '\'' + ", value='" + this.value + '\'' + '}';
    }

    public int getIntValueMaybeResolve(VariableRegistry registry) {
        try {
            return this.getIntValue();
        }
        catch (NumberFormatException e) {
            String resolvedValue = registry.get(this.value);
            Objects.requireNonNull(resolvedValue, this.value);
            return Integer.parseInt(resolvedValue);
        }
    }
}

