/*
 * Decompiled with CFR 0.152.
 */
package net.ericaro.surfaceplotter;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import net.ericaro.surfaceplotter.DefaultSurfaceModel;
import net.ericaro.surfaceplotter.Mapper;
import net.ericaro.surfaceplotter.beans.JGridBagScrollPane;
import net.ericaro.surfaceplotter.surface.AbstractSurfaceModel;
import net.ericaro.surfaceplotter.surface.JSurface;
import net.ericaro.surfaceplotter.surface.SurfaceModel;
import net.ericaro.surfaceplotter.surface.VerticalConfigurationPanel;

public class JSurfacePanel
extends JPanel {
    private JLabel title;
    private JSurface surface;
    private JGridBagScrollPane scrollpane;
    private VerticalConfigurationPanel configurationPanel;
    private AbstractAction configurationToggler;

    public JSurfacePanel() {
        this(JSurfacePanel.createDefaultSurfaceModel());
    }

    private static SurfaceModel createDefaultSurfaceModel() {
        DefaultSurfaceModel sm = new DefaultSurfaceModel();
        sm.setPlotFunction2(false);
        sm.setCalcDivisions(50);
        sm.setDispDivisions(50);
        sm.setContourLines(10);
        sm.setXMin(-3.0f);
        sm.setXMax(3.0f);
        sm.setYMin(-3.0f);
        sm.setYMax(3.0f);
        sm.setBoxed(false);
        sm.setDisplayXY(false);
        sm.setExpectDelay(false);
        sm.setAutoScaleZ(true);
        sm.setDisplayZ(false);
        sm.setMesh(false);
        sm.setPlotType(SurfaceModel.PlotType.SURFACE);
        sm.setFirstFunctionOnly(true);
        sm.setPlotColor(SurfaceModel.PlotColor.SPECTRUM);
        sm.setMapper(new Mapper(){

            public float f1(float x, float y) {
                float r = x * x + y * y;
                if (r == 0.0f) {
                    return 1.0f;
                }
                return (float)(Math.sin(r) / (double)r);
            }

            public float f2(float x, float y) {
                return (float)Math.sin(x * y);
            }
        });
        sm.plot().execute();
        return sm;
    }

    public JSurfacePanel(SurfaceModel model) {
        super(new BorderLayout());
        this.initComponents();
        String name = (String)this.configurationToggler.getValue("Name");
        this.getActionMap().put(name, this.configurationToggler);
        this.getInputMap(1).put(KeyStroke.getKeyStroke(113, 0), name);
        this.setModel(model);
    }

    public void setModel(SurfaceModel model) {
        if (model instanceof AbstractSurfaceModel) {
            this.configurationPanel.setModel((AbstractSurfaceModel)model);
        } else {
            this.scrollpane.setVisible(false);
            this.configurationPanel.setModel(null);
        }
        this.surface.setModel(model);
    }

    public Font getTitleFont() {
        return this.title.getFont();
    }

    public Icon getTitleIcon() {
        return this.title.getIcon();
    }

    public String getTitleText() {
        return this.title.getText();
    }

    public boolean isTitleVisible() {
        return this.title.isVisible();
    }

    public void setTitleFont(Font font) {
        this.title.setFont(font);
    }

    public void setTitleIcon(Icon icon) {
        this.title.setIcon(icon);
    }

    public void setTitleText(String text) {
        this.title.setText(text);
    }

    public void setTitleVisible(boolean aFlag) {
        this.title.setVisible(aFlag);
    }

    public boolean isConfigurationVisible() {
        return this.scrollpane.isVisible();
    }

    public void setConfigurationVisible(boolean aFlag) {
        this.scrollpane.setVisible(aFlag);
        this.invalidate();
        this.revalidate();
    }

    private void toggleConfiguration() {
        this.setConfigurationVisible(!this.isConfigurationVisible());
        if (!this.isConfigurationVisible()) {
            this.surface.requestFocusInWindow();
        }
    }

    public JSurface getSurface() {
        return this.surface;
    }

    private void mousePressed() {
        this.surface.requestFocusInWindow();
    }

    private void surfaceMouseClicked(MouseEvent e) {
        if (e.getClickCount() >= 2) {
            this.toggleConfiguration();
        }
    }

    private void initComponents() {
        ResourceBundle bundle = ResourceBundle.getBundle("net.ericaro.surfaceplotter.JSurfacePanel");
        this.title = new JLabel();
        this.surface = new JSurface();
        this.scrollpane = new JGridBagScrollPane();
        this.configurationPanel = new VerticalConfigurationPanel();
        this.configurationToggler = new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                JSurfacePanel.this.toggleConfiguration();
            }
        };
        this.setName("this");
        this.setLayout(new GridBagLayout());
        ((GridBagLayout)this.getLayout()).columnWidths = new int[]{0, 0, 0};
        ((GridBagLayout)this.getLayout()).rowHeights = new int[]{0, 0, 0};
        ((GridBagLayout)this.getLayout()).columnWeights = new double[]{1.0, 0.0, 1.0E-4};
        ((GridBagLayout)this.getLayout()).rowWeights = new double[]{0.0, 1.0, 1.0E-4};
        this.title.setText(bundle.getString("title.text"));
        this.title.setHorizontalTextPosition(0);
        this.title.setHorizontalAlignment(0);
        this.title.setBackground(Color.white);
        this.title.setOpaque(true);
        this.title.setFont(this.title.getFont().deriveFont((float)this.title.getFont().getSize() + 4.0f));
        this.title.setName("title");
        this.add((Component)this.title, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.surface.setToolTipText(bundle.getString("surface.toolTipText"));
        this.surface.setInheritsPopupMenu(true);
        this.surface.setName("surface");
        this.surface.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                JSurfacePanel.this.surfaceMouseClicked(e);
            }

            public void mousePressed(MouseEvent e) {
                JSurfacePanel.this.mousePressed();
            }
        });
        this.add((Component)this.surface, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.scrollpane.setWidthFixed(true);
        this.scrollpane.setName("scrollpane");
        this.configurationPanel.setNextFocusableComponent(this);
        this.configurationPanel.setName("configurationPanel");
        this.scrollpane.setViewportView(this.configurationPanel);
        this.add((Component)this.scrollpane, new GridBagConstraints(1, 0, 1, 2, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.configurationToggler.putValue("Name", bundle.getString("configurationToggler.Name"));
    }
}

