/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.steelseries.extras;

import eu.hansolo.steelseries.gauges.AbstractGauge;
import eu.hansolo.steelseries.gauges.AbstractRadial;
import eu.hansolo.steelseries.tools.FrameType;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.LinearGradientPaint;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.image.BufferedImage;
import org.pushingpixels.trident.Timeline;
import org.pushingpixels.trident.ease.Spline;

public class Horizon
extends AbstractRadial {
    private double roll;
    private double oldRoll;
    private double pitch;
    private double oldPitch;
    private double pitchPixel;
    private boolean upsidedown = false;
    private final Point2D CENTER = new Point2D.Double();
    private BufferedImage bImage;
    private BufferedImage fImage;
    private BufferedImage horizonImage;
    private BufferedImage horizonForegroundImage;
    private boolean customColors = false;
    private Color customSkyColor;
    private Color customGroundColor;
    private BufferedImage disabledImage;
    private final Ellipse2D CLIP = new Ellipse2D.Double();
    private Timeline timelineRoll = new Timeline(this);
    private Timeline timelinePitch = new Timeline(this);

    public Horizon() {
        this.customSkyColor = new Color(127, 213, 240, 255);
        this.customGroundColor = new Color(60, 68, 57, 255);
        this.init(this.getInnerBounds().width, this.getInnerBounds().height);
        this.pitch = 0.0;
        this.roll = 0.0;
    }

    @Override
    public final AbstractGauge init(int n, int n2) {
        int n3;
        int n4 = this.isFrameVisible() ? n : this.getGaugeBounds().width;
        int n5 = n3 = this.isFrameVisible() ? n2 : this.getGaugeBounds().height;
        if (n4 <= 1 || n3 <= 1) {
            return this;
        }
        if (!this.isFrameVisible()) {
            this.setFramelessOffset((double)(-this.getGaugeBounds().width) * 0.0841121495, (double)(-this.getGaugeBounds().width) * 0.0841121495);
        } else {
            this.setFramelessOffset(this.getGaugeBounds().x, this.getGaugeBounds().y);
        }
        this.CLIP.setFrame((double)n4 * 0.08411215245723724, (double)n4 * 0.08411215245723724, (double)n4 * 0.8317756652832031, (double)n4 * 0.8317756652832031);
        this.pitchPixel = (double)((int)(Math.PI * (double)n4)) / 360.0;
        if (this.bImage != null) {
            this.bImage.flush();
        }
        this.bImage = UTIL.createImage(n4, n4, 3);
        if (this.fImage != null) {
            this.fImage.flush();
        }
        this.fImage = UTIL.createImage(n4, n4, 3);
        if (this.isFrameVisible()) {
            switch (this.getFrameType()) {
                case ROUND: {
                    FRAME_FACTORY.createRadialFrame(n4, this.getFrameDesign(), this.getCustomFrameDesign(), this.getFrameEffect(), this.bImage);
                    break;
                }
                case SQUARE: {
                    FRAME_FACTORY.createLinearFrame(n4, n4, this.getFrameDesign(), this.getCustomFrameDesign(), this.getFrameEffect(), this.bImage);
                    break;
                }
                default: {
                    FRAME_FACTORY.createRadialFrame(n4, this.getFrameDesign(), this.getCustomFrameDesign(), this.getFrameEffect(), this.bImage);
                }
            }
        }
        if (this.horizonImage != null) {
            this.horizonImage.flush();
        }
        this.horizonImage = this.create_HORIZON_Image(n4);
        this.create_INDICATOR_Image(n4, this.fImage);
        if (this.horizonForegroundImage != null) {
            this.horizonForegroundImage.flush();
        }
        this.horizonForegroundImage = this.create_HORIZON_FOREGROUND_Image(n4);
        if (this.isForegroundVisible()) {
            switch (this.getFrameType()) {
                case SQUARE: {
                    FOREGROUND_FACTORY.createLinearForeground(n4, n4, false, this.fImage);
                    break;
                }
                default: {
                    FOREGROUND_FACTORY.createRadialForeground(n4, false, this.getForegroundType(), this.fImage);
                }
            }
        }
        if (this.disabledImage != null) {
            this.disabledImage.flush();
        }
        this.disabledImage = this.create_DISABLED_Image(n4);
        return this;
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        if (!this.isInitialized()) {
            return;
        }
        Graphics2D graphics2D = (Graphics2D)graphics.create();
        this.CENTER.setLocation(this.getGaugeBounds().getCenterX(), this.getGaugeBounds().getCenterX());
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        graphics2D.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
        graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        graphics2D.translate(this.getFramelessOffset().getX(), this.getFramelessOffset().getY());
        AffineTransform affineTransform = graphics2D.getTransform();
        Shape shape = graphics2D.getClip();
        graphics2D.setClip(this.CLIP);
        graphics2D.rotate(-Math.toRadians(this.roll), this.CENTER.getX(), this.CENTER.getY());
        graphics2D.translate(0.0, -(this.pitch * this.pitchPixel) - this.getFramelessOffset().getY());
        graphics2D.drawImage((Image)this.horizonImage, 0, (int)((double)(this.getHeight() - this.horizonImage.getHeight()) / 2.0), null);
        graphics2D.translate(-this.getFramelessOffset().getX(), this.pitch * this.pitchPixel + this.getFramelessOffset().getY());
        graphics2D.drawImage((Image)this.horizonForegroundImage, (int)((double)this.getWidth() * 0.5 - (double)this.horizonForegroundImage.getWidth() / 2.0), (int)((double)this.getWidth() * 0.10747663551401869), null);
        graphics2D.setTransform(affineTransform);
        graphics2D.setClip(shape);
        graphics2D.drawImage((Image)this.bImage, 0, 0, null);
        graphics2D.drawImage((Image)this.fImage, 0, 0, null);
        if (!this.isEnabled()) {
            graphics2D.drawImage((Image)this.disabledImage, 0, 0, null);
        }
        graphics2D.dispose();
    }

    public double getRoll() {
        return this.roll;
    }

    public void setRoll(double d) {
        this.oldRoll = this.roll = d % 360.0;
        this.fireStateChanged();
        this.repaint();
    }

    public void setRollAnimated(double d) {
        if (this.isEnabled()) {
            if (this.timelineRoll.getState() == Timeline.TimelineState.PLAYING_FORWARD || this.timelineRoll.getState() == Timeline.TimelineState.PLAYING_REVERSE) {
                this.timelineRoll.abort();
            }
            this.timelineRoll = new Timeline(this);
            this.timelineRoll.addPropertyToInterpolate("roll", this.oldRoll, d);
            this.timelineRoll.setEase(new Spline(0.5f));
            this.timelineRoll.setDuration(800L);
            this.timelineRoll.play();
        }
    }

    public double getPitch() {
        return this.pitch;
    }

    public void setPitch(double d) {
        this.pitch = d % 180.0;
        if (this.pitch > 90.0) {
            this.pitch = 90.0 - (this.pitch - 90.0);
            if (!this.upsidedown) {
                this.setRoll(this.roll - 180.0);
            }
            this.upsidedown = true;
        } else if (this.pitch < -90.0) {
            this.pitch = -90.0 + (-90.0 - this.pitch);
            if (!this.upsidedown) {
                this.setRoll(this.roll + 180.0);
            }
            this.upsidedown = true;
        } else {
            this.upsidedown = false;
            this.oldPitch = this.pitch;
        }
        this.fireStateChanged();
        this.repaint();
    }

    public void setPitchAnimated(double d) {
        if (this.isEnabled()) {
            if (this.timelinePitch.getState() == Timeline.TimelineState.PLAYING_FORWARD || this.timelinePitch.getState() == Timeline.TimelineState.PLAYING_REVERSE) {
                this.timelinePitch.abort();
            }
            this.timelinePitch = new Timeline(this);
            this.timelinePitch.addPropertyToInterpolate("pitch", this.oldPitch, d);
            this.timelinePitch.setEase(new Spline(0.5f));
            this.timelinePitch.setDuration(800L);
            this.timelinePitch.play();
        }
    }

    public boolean isCustomColors() {
        return this.customColors;
    }

    public void setCustomColors(boolean bl) {
        this.customColors = bl;
        if (this.customColors) {
            this.init(this.getInnerBounds().width, this.getInnerBounds().height);
            this.repaint(this.getInnerBounds());
        }
    }

    public Color getCustomSkyColor() {
        return this.customSkyColor;
    }

    public void setCustomSkyColor(Color color) {
        this.customSkyColor = color;
        this.init(this.getInnerBounds().width, this.getInnerBounds().height);
        this.repaint(this.getInnerBounds());
    }

    public Color getCustomGroundColor() {
        return this.customGroundColor;
    }

    public void setCustomGroundColor(Color color) {
        this.customGroundColor = color;
        this.init(this.getInnerBounds().width, this.getInnerBounds().height);
        this.repaint(this.getInnerBounds());
    }

    @Override
    public void setFrameType(FrameType frameType) {
        super.setFrameType(FrameType.ROUND);
    }

    @Override
    public Point2D getCenter() {
        return new Point2D.Double((double)this.bImage.getWidth() / 2.0 + (double)this.getInnerBounds().x, (double)this.bImage.getHeight() / 2.0 + (double)this.getInnerBounds().y);
    }

    @Override
    public Rectangle2D getBounds2D() {
        return new Rectangle2D.Double(this.bImage.getMinX(), this.bImage.getMinY(), this.bImage.getWidth(), this.bImage.getHeight());
    }

    @Override
    public Rectangle getLcdBounds() {
        return new Rectangle();
    }

    private BufferedImage create_HORIZON_Image(int n) {
        TextLayout textLayout;
        if (n <= 0) {
            return UTIL.createImage(1, 1, 3);
        }
        int n2 = (int)(Math.PI * (double)n);
        BufferedImage bufferedImage = UTIL.createImage(n, n2, 3);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
        int n3 = bufferedImage.getWidth();
        int n4 = bufferedImage.getHeight();
        Rectangle2D.Double double_ = new Rectangle2D.Double(0.0, 0.0, n3, n2);
        Point2D.Double double_2 = new Point2D.Double(0.0, ((Rectangle2D)double_).getBounds2D().getMinY());
        Point2D.Double double_3 = new Point2D.Double(0.0, ((Rectangle2D)double_).getBounds2D().getMaxY());
        float[] fArray = new float[]{0.0f, 0.49999f, 0.5f, 1.0f};
        Color[] colorArray = this.customColors ? new Color[]{this.customSkyColor, this.customSkyColor, this.customGroundColor, this.customGroundColor} : new Color[]{new Color(127, 213, 240, 255), new Color(127, 213, 240, 255), new Color(60, 68, 57, 255), new Color(60, 68, 57, 255)};
        LinearGradientPaint linearGradientPaint = new LinearGradientPaint(double_2, double_3, fArray, colorArray);
        graphics2D.setPaint(linearGradientPaint);
        graphics2D.fill(double_);
        graphics2D.setColor(UTIL.setBrightness(colorArray[0], 0.5f));
        Line2D.Double double_4 = new Line2D.Double();
        double d = (double)n2 / 360.0 * 5.0;
        boolean bl = false;
        int n5 = 0;
        graphics2D.setFont(new Font("Verdana", 0, (int)((double)n * 0.04)));
        FontRenderContext fontRenderContext = new FontRenderContext(null, true, true);
        Rectangle2D.Double double_5 = new Rectangle2D.Double();
        for (double d2 = (double)n4 / 2.0 - d; d2 > 0.0; d2 -= d) {
            if (n5 <= 80) {
                if (bl) {
                    ((Line2D)double_4).setLine(((double)n3 - (double)n3 * 0.2) / 2.0, d2, (double)n3 - ((double)n3 - (double)n3 * 0.2) / 2.0, d2);
                    textLayout = new TextLayout(Integer.toString(n5 += 10), graphics2D.getFont(), fontRenderContext);
                    double_5.setFrame(textLayout.getBounds());
                    graphics2D.drawString(Integer.toString(n5), (float)(((Line2D)double_4).getX1() - ((RectangularShape)double_5).getWidth() - 5.0), (float)(d2 + ((RectangularShape)double_5).getHeight() / 2.0));
                    graphics2D.drawString(Integer.toString(n5), (float)(((Line2D)double_4).getX2() + 5.0), (float)(d2 + ((RectangularShape)double_5).getHeight() / 2.0));
                } else {
                    ((Line2D)double_4).setLine(((double)n3 - (double)n3 * 0.1) / 2.0, d2, (double)n3 - ((double)n3 - (double)n3 * 0.1) / 2.0, d2);
                }
                graphics2D.draw(double_4);
            }
            bl ^= true;
        }
        bl = false;
        n5 = 0;
        graphics2D.setColor(Color.WHITE);
        Stroke stroke = graphics2D.getStroke();
        graphics2D.setStroke(new BasicStroke(1.5f));
        ((Line2D)double_4).setLine(0.0, (double)n4 / 2.0, n3, (double)n4 / 2.0);
        graphics2D.draw(double_4);
        graphics2D.setStroke(stroke);
        for (double d3 = (double)n4 / 2.0 + d; d3 <= (double)n4; d3 += d) {
            if (n5 >= -80) {
                if (bl) {
                    ((Line2D)double_4).setLine(((double)n3 - (double)n3 * 0.2) / 2.0, d3, (double)n3 - ((double)n3 - (double)n3 * 0.2) / 2.0, d3);
                    textLayout = new TextLayout(Integer.toString(n5 -= 10), graphics2D.getFont(), fontRenderContext);
                    double_5.setFrame(textLayout.getBounds());
                    graphics2D.drawString(Integer.toString(n5), (float)(((Line2D)double_4).getX1() - ((RectangularShape)double_5).getWidth() - 5.0), (float)(d3 + ((RectangularShape)double_5).getHeight() / 2.0));
                    graphics2D.drawString(Integer.toString(n5), (float)(((Line2D)double_4).getX2() + 5.0), (float)(d3 + ((RectangularShape)double_5).getHeight() / 2.0));
                } else {
                    ((Line2D)double_4).setLine(((double)n3 - (double)n3 * 0.1) / 2.0, d3, (double)n3 - ((double)n3 - (double)n3 * 0.1) / 2.0, d3);
                }
                graphics2D.draw(double_4);
            }
            bl ^= true;
        }
        graphics2D.dispose();
        return bufferedImage;
    }

    private BufferedImage create_INDICATOR_Image(int n, BufferedImage bufferedImage) {
        if (n <= 0) {
            return UTIL.createImage(1, 1, 3);
        }
        if (bufferedImage == null) {
            bufferedImage = UTIL.createImage(n, n, 3);
        }
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
        int n2 = bufferedImage.getWidth();
        int n3 = bufferedImage.getHeight();
        Point2D.Double double_ = new Point2D.Double((double)n2 / 2.0, (double)n3 / 2.0);
        graphics2D.setFont(new Font("Verdana", 0, (int)((double)n2 * 0.035)));
        Line2D.Double double_2 = new Line2D.Double((double)n2 * 0.5, (double)n3 * 0.08878504672897196, (double)n2 * 0.5, (double)n3 * 0.0937850467);
        Line2D.Double double_3 = new Line2D.Double((double)n2 * 0.5, (double)n3 * 0.08878504672897196, (double)n2 * 0.5, (double)n3 * 0.1037850467);
        Line2D.Double double_4 = new Line2D.Double((double)n2 * 0.5, (double)n3 * 0.08878504672897196, (double)n2 * 0.5, (double)n3 * 0.113);
        BasicStroke basicStroke = new BasicStroke(0.5f, 1, 1);
        BasicStroke basicStroke2 = new BasicStroke(1.0f, 1, 1);
        BasicStroke basicStroke3 = new BasicStroke(2.0f, 1, 1);
        AffineTransform affineTransform = graphics2D.getTransform();
        graphics2D.rotate(-1.5707963267948966, ((Point2D)double_).getX(), ((Point2D)double_).getY());
        for (int i = -90; i <= 90; i += 5) {
            if (i % 45 == 0 || i == 0) {
                graphics2D.setColor(this.getPointerColor().MEDIUM);
                graphics2D.setStroke(basicStroke3);
                graphics2D.draw(double_4);
            } else if (i % 15 == 0) {
                graphics2D.setColor(Color.WHITE);
                graphics2D.setStroke(basicStroke2);
                graphics2D.draw(double_3);
            } else {
                graphics2D.setColor(Color.WHITE);
                graphics2D.setStroke(basicStroke);
                graphics2D.draw(double_2);
            }
            graphics2D.rotate(Math.toRadians(5.0), ((Point2D)double_).getX(), ((Point2D)double_).getY());
        }
        graphics2D.setTransform(affineTransform);
        GeneralPath generalPath = new GeneralPath();
        generalPath.setWindingRule(0);
        generalPath.moveTo((double)n2 * 0.4766355140186916, (double)n3 * 0.5);
        generalPath.curveTo((double)n2 * 0.4766355140186916, (double)n3 * 0.514018691588785, (double)n2 * 0.48598130841121495, (double)n3 * 0.5233644859813084, (double)n2 * 0.5, (double)n3 * 0.5233644859813084);
        generalPath.curveTo((double)n2 * 0.514018691588785, (double)n3 * 0.5233644859813084, (double)n2 * 0.5233644859813084, (double)n3 * 0.514018691588785, (double)n2 * 0.5233644859813084, (double)n3 * 0.5);
        generalPath.curveTo((double)n2 * 0.5233644859813084, (double)n3 * 0.48598130841121495, (double)n2 * 0.514018691588785, (double)n3 * 0.4766355140186916, (double)n2 * 0.5, (double)n3 * 0.4766355140186916);
        generalPath.curveTo((double)n2 * 0.48598130841121495, (double)n3 * 0.4766355140186916, (double)n2 * 0.4766355140186916, (double)n3 * 0.48598130841121495, (double)n2 * 0.4766355140186916, (double)n3 * 0.5);
        generalPath.closePath();
        generalPath.moveTo((double)n2 * 0.4158878504672897, (double)n3 * 0.5046728971962616);
        generalPath.lineTo((double)n2 * 0.4158878504672897, (double)n3 * 0.4953271028037383);
        generalPath.curveTo((double)n2 * 0.4158878504672897, (double)n3 * 0.4953271028037383, (double)n2 * 0.4672897196261682, (double)n3 * 0.4953271028037383, (double)n2 * 0.4672897196261682, (double)n3 * 0.4953271028037383);
        generalPath.curveTo((double)n2 * 0.4719626168224299, (double)n3 * 0.48130841121495327, (double)n2 * 0.48130841121495327, (double)n3 * 0.4719626168224299, (double)n2 * 0.4953271028037383, (double)n3 * 0.4672897196261682);
        generalPath.curveTo((double)n2 * 0.4953271028037383, (double)n3 * 0.4672897196261682, (double)n2 * 0.4953271028037383, (double)n3 * 0.4158878504672897, (double)n2 * 0.4953271028037383, (double)n3 * 0.4158878504672897);
        generalPath.lineTo((double)n2 * 0.5046728971962616, (double)n3 * 0.4158878504672897);
        generalPath.curveTo((double)n2 * 0.5046728971962616, (double)n3 * 0.4158878504672897, (double)n2 * 0.5046728971962616, (double)n3 * 0.4672897196261682, (double)n2 * 0.5046728971962616, (double)n3 * 0.4672897196261682);
        generalPath.curveTo((double)n2 * 0.5186915887850467, (double)n3 * 0.4719626168224299, (double)n2 * 0.5280373831775701, (double)n3 * 0.48130841121495327, (double)n2 * 0.5327102803738317, (double)n3 * 0.4953271028037383);
        generalPath.curveTo((double)n2 * 0.5327102803738317, (double)n3 * 0.4953271028037383, (double)n2 * 0.5841121495327103, (double)n3 * 0.4953271028037383, (double)n2 * 0.5841121495327103, (double)n3 * 0.4953271028037383);
        generalPath.lineTo((double)n2 * 0.5841121495327103, (double)n3 * 0.5046728971962616);
        generalPath.curveTo((double)n2 * 0.5841121495327103, (double)n3 * 0.5046728971962616, (double)n2 * 0.5327102803738317, (double)n3 * 0.5046728971962616, (double)n2 * 0.5327102803738317, (double)n3 * 0.5046728971962616);
        generalPath.curveTo((double)n2 * 0.5280373831775701, (double)n3 * 0.5186915887850467, (double)n2 * 0.5186915887850467, (double)n3 * 0.5327102803738317, (double)n2 * 0.5, (double)n3 * 0.5327102803738317);
        generalPath.curveTo((double)n2 * 0.48130841121495327, (double)n3 * 0.5327102803738317, (double)n2 * 0.4719626168224299, (double)n3 * 0.5186915887850467, (double)n2 * 0.4672897196261682, (double)n3 * 0.5046728971962616);
        generalPath.curveTo((double)n2 * 0.4672897196261682, (double)n3 * 0.5046728971962616, (double)n2 * 0.4158878504672897, (double)n3 * 0.5046728971962616, (double)n2 * 0.4158878504672897, (double)n3 * 0.5046728971962616);
        generalPath.closePath();
        graphics2D.setPaint(this.getPointerColor().LIGHT);
        graphics2D.fill(generalPath);
        graphics2D.dispose();
        return bufferedImage;
    }

    private BufferedImage create_HORIZON_FOREGROUND_Image(int n) {
        if (n <= 0) {
            return UTIL.createImage(1, 1, 3);
        }
        BufferedImage bufferedImage = UTIL.createImage((int)((double)n * 0.0373831776), (int)((double)n * 0.0560747664), 3);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
        int n2 = bufferedImage.getWidth();
        int n3 = bufferedImage.getHeight();
        GeneralPath generalPath = new GeneralPath();
        generalPath.setWindingRule(0);
        generalPath.moveTo((double)n2 * 0.5, 0.0);
        generalPath.lineTo(0.0f, n3);
        generalPath.lineTo(n2, n3);
        generalPath.closePath();
        graphics2D.setColor(this.getPointerColor().LIGHT);
        graphics2D.fill(generalPath);
        graphics2D.setColor(this.getPointerColor().MEDIUM);
        graphics2D.draw(generalPath);
        graphics2D.dispose();
        return bufferedImage;
    }

    @Override
    public String toString() {
        return "Horizon";
    }
}

