/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi.ui.etb;

import com.rusefi.core.MessagesCentral;
import com.rusefi.core.Sensor;
import com.rusefi.core.SensorCentral;
import com.rusefi.ui.UIContext;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JComponent;

public class EtbReturnToNeutral {
    private static final int ZERO_POSITION = 0;
    private static final int NEUTRAL_POSITION = 7;
    private static final int ACCEPTABLE_ERROR = 1;
    private static final int CYCLES_COUNT = 10;
    private static final String ZERO_DUTY_CYCLE_COMMAND = "set_etb_duty 0";
    private final UIContext uiContext;
    private JButton button = new JButton("ETB Spring Test");
    private static final float SHUT_OPEN = 70.0f;
    private static final float SHUT_CLOSED = -70.0f;

    public EtbReturnToNeutral(UIContext uiContext) {
        this.uiContext = uiContext;
        this.button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        try {
                            EtbReturnToNeutral.this.testSequence();
                        }
                        catch (InterruptedException e1) {
                            throw new IllegalStateException(e1);
                        }
                    }
                };
                new Thread(runnable).start();
            }
        });
    }

    private void testSequence() throws InterruptedException {
        this.uiContext.getCommandQueue().write(ZERO_DUTY_CYCLE_COMMAND);
        Thread.sleep(2000L);
        this.assertPosition("First neutral position expected.", 7.0f);
        int errorCount = 0;
        for (int i = 1; i <= 10; ++i) {
            this.uiContext.getCommandQueue().write(ZERO_DUTY_CYCLE_COMMAND);
            Thread.sleep(1000L);
            boolean isError = this.assertPosition(i + ": Neutral position expected.", 7.0f);
            if (isError) {
                ++errorCount;
            }
            this.uiContext.getCommandQueue().write("set_etb_duty 70.0");
            Thread.sleep(500L);
            this.uiContext.getCommandQueue().write("set_etb_duty -70.0");
            Thread.sleep(1000L);
            isError = this.assertPosition(i + ": Should be shot closed", 0.0f);
            if (!isError) continue;
            ++errorCount;
        }
        this.uiContext.getCommandQueue().write(ZERO_DUTY_CYCLE_COMMAND);
        MessagesCentral.getInstance().postMessage(this.getClass(), "Cycles = 10, errors = " + errorCount);
    }

    private boolean assertPosition(String msg, float expectedPosition) {
        boolean isError;
        double tps = SensorCentral.getInstance().getValue(Sensor.TPS);
        MessagesCentral.getInstance().postMessage(this.getClass(), msg + " TPS=" + tps);
        boolean bl = isError = Math.abs(tps - (double)expectedPosition) > 1.0;
        if (isError) {
            MessagesCentral.getInstance().postMessage(this.getClass(), msg + " NOT GREAT " + tps + " while expected " + expectedPosition);
        }
        return isError;
    }

    public JComponent getContent() {
        return this.button;
    }
}

