/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi.ui.etb;

import com.rusefi.ui.UIContext;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import org.putgemin.VerticalFlowLayout;

public class DirectDrivePanel {
    public static final String CANCEL_DIRECT_DRIVE_COMMAND = "set_etb_duty NaN";
    private final JPanel content = new JPanel(new BorderLayout());
    private final JLabel currentOverride = new JLabel("NaN");
    private final JTextArea increment = new JTextArea("0.5");
    private final JButton reset = new JButton("Cancel Direct Drive");
    private double directDriverValue;

    public DirectDrivePanel(final UIContext uiContext) {
        this.content.setBorder(BorderFactory.createTitledBorder("Direct Drive"));
        uiContext.getCommandQueue().addListener(command -> {
            if (command.startsWith("set_etb_duty ")) {
                command = command.substring("set_etb_duty ".length());
                this.directDriverValue = this.parseDouble((String)command, Double.NaN);
                SwingUtilities.invokeLater(() -> this.currentOverride.setText("PWM override " + this.directDriverValue));
                this.reset.setEnabled(!Double.isNaN(this.directDriverValue));
            }
        });
        JPanel upDownPanel = new JPanel(new GridLayout(2, 1));
        JButton more = new JButton("More");
        more.addActionListener(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                double newValue = DirectDrivePanel.this.getCurrent() + DirectDrivePanel.this.getIncrement();
                uiContext.getCommandQueue().write("set_etb_duty " + newValue);
            }
        });
        upDownPanel.add(more);
        JButton less = new JButton("Less");
        upDownPanel.add(less);
        less.addActionListener(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                double newValue = DirectDrivePanel.this.getCurrent() - DirectDrivePanel.this.getIncrement();
                uiContext.getCommandQueue().write("set_etb_duty " + newValue);
            }
        });
        JPanel leftPanel = new JPanel(new VerticalFlowLayout());
        this.reset.addActionListener(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                uiContext.getCommandQueue().write(DirectDrivePanel.CANCEL_DIRECT_DRIVE_COMMAND);
            }
        });
        leftPanel.add(this.reset);
        leftPanel.add(this.currentOverride);
        leftPanel.add(new JLabel("Increment:"));
        leftPanel.add(this.increment);
        this.content.add((Component)leftPanel, "Center");
        this.content.add((Component)upDownPanel, "East");
    }

    private double parseDouble(String text, double defaultValue) {
        try {
            return Double.parseDouble(text);
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    private double getIncrement() {
        try {
            double value = Double.parseDouble(this.increment.getText());
            return Double.isNaN(value) ? 0.5 : value;
        }
        catch (NumberFormatException e) {
            this.increment.setText("0.5");
            return 0.5;
        }
    }

    private double getCurrent() {
        return Double.isNaN(this.directDriverValue) ? 0.0 : this.directDriverValue;
    }

    public JPanel getContent() {
        return this.content;
    }
}

