/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi.util;

import com.rusefi.util.IoUtils;
import com.rusefi.util.Output;
import com.rusefi.util.SystemOut;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.nio.file.Paths;
import java.util.Scanner;
import java.util.regex.Pattern;

public class LazyFile
implements Output {
    public static final String LAZY_FILE_TAG = "was generated automatically by rusEFI tool ";
    public static final String LAZY_FILE_TAG_LOWER = "was generated automatically by rusEFI tool ".toLowerCase();
    public static String TEST = "test_file_name";
    private final String filename;
    private final StringBuffer content = new StringBuffer();
    private final StringBuffer contentWithoutTag = new StringBuffer();

    public LazyFile(String filename) {
        this.filename = filename;
    }

    @Override
    public void write(String line) {
        String[] lines;
        this.content.append(line);
        for (String subLine : lines = line.split("\\r?\\n")) {
            if (subLine.toLowerCase().contains(LAZY_FILE_TAG_LOWER)) continue;
            this.contentWithoutTag.append(subLine);
        }
    }

    @Override
    public void close() throws IOException {
        String newContent;
        if (TEST.equals(this.filename)) {
            return;
        }
        String fileContent = LazyFile.unifySpaces(this.readCurrentContent(this.filename));
        if (fileContent.equals(newContent = LazyFile.unifySpaces(this.contentWithoutTag.toString()))) {
            SystemOut.println(this.getClass().getSimpleName() + ": Not updating " + this.filename + " since looks to be the same content, new content size=" + this.contentWithoutTag.length());
            return;
        }
        for (int i = 0; i < Math.min(fileContent.length(), newContent.length()); ++i) {
            if (fileContent.charAt(i) == newContent.charAt(i)) continue;
            SystemOut.println(this.getClass().getSimpleName() + " " + this.filename + ": Not same at " + i);
            if (i <= 15 || i >= fileContent.length() - 6 || i >= newContent.length() - 6) break;
            SystemOut.println("file       " + fileContent.substring(i - 15, i + 5));
            SystemOut.println("newContent " + newContent.substring(i - 15, i + 5));
            break;
        }
        PrintWriter fw = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.filename), IoUtils.CHARSET));
        ((Writer)fw).write(this.content.toString());
        ((Writer)fw).close();
    }

    public static String unifySpaces(String line) {
        line = line.replace("\r", "");
        return line.replaceAll("\n[\n]*", "");
    }

    private String readCurrentContent(String filename) throws IOException {
        String line;
        if (TEST.equals(filename)) {
            return "";
        }
        if (!new File(filename).exists()) {
            SystemOut.println(filename + " does not exist considering empty current content");
            return "";
        }
        Scanner in = new Scanner(Paths.get(filename, new String[0]), IoUtils.CHARSET.name());
        Pattern pat = Pattern.compile(".*\\R|.+\\z");
        StringBuilder sb = new StringBuilder();
        while ((line = in.findWithinHorizon(pat, 0)) != null) {
            if (line.toLowerCase().contains(LAZY_FILE_TAG_LOWER)) continue;
            sb.append(line);
        }
        return sb.toString();
    }
}

