/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi.output;

import com.rusefi.ExtraUtil;
import com.rusefi.FirmwareVersion;
import com.rusefi.ReaderState;
import com.rusefi.ReaderStateImpl;
import com.rusefi.VariableRegistry;
import com.rusefi.newparse.DefinitionsState;
import com.rusefi.newparse.parsing.Definition;
import com.rusefi.output.ConfigStructure;
import com.rusefi.output.ConfigurationConsumer;
import com.rusefi.util.SystemOut;
import java.io.IOException;

public class SignatureConsumer
implements ConfigurationConsumer {
    private final String destHeader;
    private final VariableRegistry registry;

    public SignatureConsumer(String destHeader, VariableRegistry registry) {
        SystemOut.println("Writing Signature header to " + destHeader);
        this.destHeader = destHeader;
        this.registry = registry;
    }

    public static void storeUniqueBuildId(ReaderStateImpl state, DefinitionsState parseState, String tsPath, FirmwareVersion uniqueId) {
        if (tsPath != null) {
            parseState.addDefinition(state.getVariableRegistry(), "SIGNATURE_HASH", uniqueId.encode(), Definition.OverwritePolicy.NotAllowed);
        }
    }

    @Override
    public void handleEndStruct(ReaderState readerState, ConfigStructure structure) throws IOException {
        ExtraUtil.writeDefinesToFile(this.registry, this.destHeader, "by SignatureConsumer");
    }
}

