/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi.models;

import com.rusefi.FileLog;
import com.rusefi.models.Point3D;
import com.rusefi.models.Range;
import com.rusefi.models.YAxisData;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.Map;
import java.util.NavigableSet;
import java.util.TreeMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XYData {
    @NotNull
    private final TreeMap<Double, YAxisData> yDatas = new TreeMap();
    private double maxXValue;
    private double minXValue;
    private double maxYValue;
    private double minYValue;
    String date = FileLog.getDate();

    public XYData() {
        this.clear();
    }

    public float getValue(double x, double y) {
        YAxisData yAxis = this.findYAxis(x);
        if (yAxis == null) {
            return Float.NaN;
        }
        return yAxis.findZ(y);
    }

    public double getMaxXValue() {
        return this.maxXValue;
    }

    public double getMinXValue() {
        return this.minXValue;
    }

    public double getMaxYValue() {
        return this.maxYValue;
    }

    public double getMinYValue() {
        return this.minYValue;
    }

    public void addPoint(int rpm, double key, float value) {
        this.addPoint(new Point3D(rpm, key, value));
    }

    public void addPoint(Point3D xyz) {
        YAxisData yAxis = this.getYdata(xyz);
        yAxis.addValue(xyz.getY(), xyz.getZ());
    }

    public void setPoint(Point3D xyz) {
        YAxisData yAxis = this.getYdata(xyz);
        yAxis.setValue(xyz.getY(), xyz.getZ());
    }

    private YAxisData getYdata(Point3D xyz) {
        this.minYValue = Math.min(this.minYValue, xyz.getY());
        this.maxYValue = Math.max(this.maxYValue, xyz.getY());
        return this.getYAxis(xyz.getX());
    }

    @NotNull
    public NavigableSet<Double> getXSet() {
        return this.yDatas.navigableKeySet();
    }

    @NotNull
    public YAxisData getYAxis(double x) {
        YAxisData result = this.yDatas.get(x);
        if (result == null) {
            result = new YAxisData(x);
            this.maxXValue = Math.max(this.maxXValue, x);
            this.minXValue = Math.min(this.minXValue, x);
            this.yDatas.put(x, result);
        }
        return result;
    }

    @Nullable
    public YAxisData findYAxis(double x) {
        double xfromSet = this.findXfromSet(x);
        if (Double.isNaN(xfromSet)) {
            return null;
        }
        return this.yDatas.get(xfromSet);
    }

    public double findXfromSet(double x) {
        Map.Entry<Double, YAxisData> floorEntry = this.yDatas.floorEntry(x);
        if (floorEntry != null) {
            return floorEntry.getKey();
        }
        Map.Entry<Double, YAxisData> ceilingEntry = this.yDatas.ceilingEntry(x);
        if (ceilingEntry == null) {
            return Double.NaN;
        }
        return ceilingEntry.getKey();
    }

    public void clear() {
        this.maxXValue = Double.MIN_VALUE;
        this.minXValue = Double.MAX_VALUE;
        this.maxYValue = Double.MIN_VALUE;
        this.minYValue = Double.MAX_VALUE;
        this.yDatas.clear();
    }

    public String toString() {
        return "XYData{yDatas.size()=" + this.yDatas.size() + '}';
    }

    public void saveToFile(String filename) {
        try {
            String name = this.date + filename;
            FileLog.MAIN.logLine("Writing data to " + name);
            FileWriter w = new FileWriter(name);
            for (YAxisData yAxisData : this.yDatas.values()) {
                yAxisData.write(w);
            }
            ((Writer)w).close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void fill(Range rpmRange, Range keyRange, int count, float value) {
        this.clear();
        for (int i = 0; i < count; ++i) {
            for (int j = 0; j < count; ++j) {
                float rpm = rpmRange.getMin() + rpmRange.getWidth() * (float)i / (float)count;
                float key = keyRange.getMin() + keyRange.getWidth() * (float)j / (float)count;
                this.addPoint(new Point3D(rpm, (double)key, value));
            }
        }
    }
}

